% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_significance.R
\name{sponge_build_null_model}
\alias{sponge_build_null_model}
\title{Build null model for p-value computation}
\usage{
sponge_build_null_model(
  number_of_datasets = 1e+05,
  number_of_samples,
  cov_matrices = precomputed_cov_matrices,
  ks = seq(0.2, 0.9, 0.1),
  m_max = 8,
  log.level = "ERROR"
)
}
\arguments{
\item{number_of_datasets}{the number of datesets defining the
precision of the p-value}

\item{number_of_samples}{the number of samples in the expression data}

\item{cov_matrices}{pre-computed covariance matrices}

\item{ks}{a sequence of gene-gene correlation values for which null models
are computed}

\item{m_max}{null models are build for each elt in ks for 1 to m_max miRNAs}

\item{log.level}{The log level of the logging package}
}
\value{
a list (for various values of m) of lists (for various values of k)
of lists of simulated data sets, drawn from a set of precomputed
covariance matrices
}
\description{
Build null model for p-value computation
}
\examples{
sponge_build_null_model(100, 100,
cov_matrices = precomputed_cov_matrices[1:3], m_max = 3)
}
