% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_splinter.R
\name{shapiroDonor}
\alias{shapiroDonor}
\title{shapiroDonor}
\usage{
shapiroDonor(reference_fasta, target_fasta)
}
\arguments{
\item{reference_fasta}{vector of strings or DNAStringSet of reference splice list}

\item{target_fasta}{vector of strings or DNAStringSet of fasta to score}
}
\value{
data.frame with Shapiro scores
}
\description{
Shapiro and Senapathy (1987) have developed a method to score the strength of a splice site
based on percentages of each nucleotide at each position.
Shapiro's score of donor site (range is from -3 [exon] to +7 [intron]) is :
100 * (t - min)/ (max - min), where
t is the sum of percentages at positions -3 to +7,
min is the sum of the lowest percentages at positions -3 to +7, and
max is the sum of the highest percentages at positions -3 to +7.
}
\examples{
library(BSgenome.Mmusculus.UCSC.mm9)
bsgenome <- BSgenome.Mmusculus.UCSC.mm9
data_path<-system.file("extdata",package="SPLINTER")
splice_data<-extractSpliceEvents(data=paste(data_path,"/skipped_exons.txt",sep=""))
splice_sites<-extractSpliceSites(splice_data)
donor.ss<-getSeq(bsgenome,splice_sites)
##sdonor<-shapiroDonor(donor.m,donor.ss)
}
\seealso{
\url{http://www.softberry.com/spldb/SpliceDB.html}
}
\author{
Diana Low
}
