% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primerpcr.R
\name{getRegionDNA}
\alias{getRegionDNA}
\title{getRegionDNA}
\usage{
getRegionDNA(roi, genome, introns = FALSE)
}
\arguments{
\item{roi}{\code{\link{makeROI}} object}

\item{genome}{BSgenome object}

\item{introns}{TRUE/FALSE. whether to include intronic (lowercase) DNA.
By default returns only exonic (uppercase) DNA.}
}
\value{
list of \cr
  (1) DNA sequence
  (2) Junction start (for primer design)
}
\description{
get DNA sequence give a region of interest
}
\examples{
suppressMessages(library(BSgenome.Mmusculus.UCSC.mm9))
bsgenome<-BSgenome.Mmusculus.UCSC.mm9
getRegionDNA(roi,bsgenome)
}
\author{
Diana Low
}
