% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_splinter.R
\name{eventOutcomeCompare}
\alias{eventOutcomeCompare}
\title{eventOutcomeCompare}
\usage{
eventOutcomeCompare(
  seq1,
  seq2 = NULL,
  genome,
  direction = TRUE,
  fullseq = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{seq1}{GRangesList}

\item{seq2}{GRangesList}

\item{genome}{BSGenome object}

\item{direction}{logical. Report direction of sequence change.}

\item{fullseq}{logical. Report full sequences.}

\item{verbose}{logical. turn messages on/off.}
}
\value{
list containing\cr
  (1) tt : PairwiseAlignmentsSingleSubject pairwise alignment\cr
  (2) eventtypes : string detailing primary event classification\cr
}
\description{
Compares two sequences and gives differences if there's a switch from 1->2
if seq2 is NULL, assume seq1 is a list of length 2 to compare
}
\examples{
suppressMessages(library(BSgenome.Mmusculus.UCSC.mm9))
bsgenome<-BSgenome.Mmusculus.UCSC.mm9
eventOutcomeCompare(seq1=compatible_cds$hits[[1]],seq2=region_minus_exon,
 genome=bsgenome,direction=TRUE)
}
\author{
Diana LOW
}
