% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spicey_plot.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Plot a SPICEY score gene-by-cell-type heatmap}
\usage{
plot_heatmap(df_z, title_text, fill_label)
}
\arguments{
\item{df_z}{A data frame with SPICEY scored values. Must contain:
\describe{
\item{gene_id}{Identifier of the gene. Must be an official gene symbol (e.g., \code{GAPDH})}.
\item{\code{cell_type}}{Cell type or cluster label (e.g., \code{Acinar})}
\item{\code{score}}{Numeric. Values of the specificity score (e.g., \code{RETSI}, \code{GETSI})}}}

\item{title_text}{Character. Title of the heatmap.}

\item{fill_label}{Character. Legend label for the color scale.}
}
\value{
A \code{ggplot2} object representing the heatmap.
}
\description{
Generates a heatmap using ggplot2 to visualize expression or accessibility
SPICEY scores for genes across different cell types. Genes are ordered by their
highest-scoring cell type, and then by maximum SPICEY score within that group.
}
\seealso{
\code{\link{prepare_heatmap_data}}, \code{\link{spicey_heatmap}}
}
