% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_re_genes.R
\name{.add_tss_annotation}
\alias{.add_tss_annotation}
\title{Add TSS annotation to peaks}
\usage{
.add_tss_annotation(
  annotation,
  peaks,
  txdb,
  annot_dbi,
  protein_coding_only,
  verbose
)
}
\arguments{
\item{annotation}{A \code{data.frame} or \code{GRanges} containing peak annotations,
including a \code{region_id} column.}

\item{peaks}{A \code{GRanges} object containing the original peak set.}

\item{txdb}{\code{TxDb} object for genome annotation (required if annotation requested).}

\item{annot_dbi}{\code{AnnotationDbi} object for gene ID mapping (required if annotation requested).}

\item{protein_coding_only}{Logical; restrict to protein-coding genes (default TRUE).}

\item{verbose}{Logical; print messages (default TRUE).}
}
\value{
A \code{data.frame} or \code{GRanges} (depending on input) with added columns:
\describe{
\item{in_TSS}{Logical, \code{TRUE} if the peak overlaps a TSS.}
\item{TSS_gene}{Gene symbol of the overlapping TSS, if any.}
}
}
\description{
Identifies transcription start sites (TSS) overlapping with input peaks and
adds logical and gene ID columns to an annotation table.
}
