% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_association_to_cell_properties.R
\name{measure_association_to_cell_properties}
\alias{measure_association_to_cell_properties}
\title{measure_association_to_cell_properties}
\usage{
measure_association_to_cell_properties(
  spe_object,
  property = "Cell.Area",
  celltypes,
  feature_colname = "Cell.Type",
  method = "density",
  Nucleus.Ratio = FALSE,
  log.scale = FALSE
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{property}{String that is the name of the column of interest.}

\item{celltypes}{String Vector of celltypes of interest.}

\item{feature_colname}{String that speficies the column of the cell types.}

\item{method}{String. The analysis to perform on the selected cell types and
property. Options are "density", "box", "t", "wilcox".}

\item{Nucleus.Ratio}{Boolean whether the ratio of the nucleus size is of
interest.}

\item{log.scale}{Boolean whether to log the data.}
}
\value{
With method "box" or "density a plot is returned. With method "t" or
  "wilcox", the text output from the test are returned.
}
\description{
Plots the density or boxplot of a property of two cell celltypes
  or compares using t test/wilcoxon rank sum test.
}
\examples{
measure_association_to_cell_properties(image_no_markers,
                                      celltypes = c("Tumour", "Immune1"),
                                      feature_colname = "Cell.Type",
                                      property = "Cell.Size",
                                      method = "box")
measure_association_to_cell_properties(image_no_markers,
                                      celltypes = c("Tumour", "Immune2"),
                                      feature_colname="Cell.Type",
                                      property = "Cell.Size",
                                      method = "t")
}
