% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_BC.R
\name{R_BC}
\alias{R_BC}
\title{The ratio of border cell count to cluster cell count}
\usage{
R_BC(spe_object, cell_type_of_interest, feature_colname)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{cell_type_of_interest}{String. The cell type that the user wants to
determine a cluster of.}

\item{feature_colname}{String. The column that contains the cell type to be clustered.}
}
\value{
A number is returned.
}
\description{
Calculates the ratio of the bordering cell count and the
  total to-be-clustered cell count in an image. The bordering cells are detected
  by the default \code{\link{identify_bordering_cells}} function. If the
  ratio is high, it means that most cells to be clustered are identified as bordering
  cells. This means there is no clear clusters.
}
\examples{
R_BC(SPIAT::defined_image, cell_type_of_interest = "Tumour", "Cell.Type")

}
