% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{renameReadGroups}
\alias{renameReadGroups}
\title{Rename read groups.}
\usage{
renameReadGroups(SNPhood.o, newReadGroupsMapping, verbose = TRUE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{newReadGroupsMapping}{Named list. Named list. For clarity of mapping, the names of the list must be the currently defined read group names, 
and the values of each element the corresponding new ones.}

\item{verbose}{Logical(1). Default TRUE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
an object of class \code{\link{SNPhood}} with the requested read groups being renamed.
}
\description{
\code{renameReadGroups} renames a set of read groups from a \emph{SNPhood} object.
}
\examples{
data(SNPhood.o, package="SNPhood")
mapping = list("a", "b", "c")
names(mapping) = annotationReadGroups(SNPhood.o)
SNPhood_mod.o = renameReadGroups (SNPhood.o, mapping)
}
\seealso{
\code{\link{renameBins}}, \code{\link{renameDatasets}}, \code{\link{renameRegions}}
}

