% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plotGenotypesPerSNP}
\alias{plotGenotypesPerSNP}
\title{Plot genotype frequencies of regions across datasets.}
\usage{
plotGenotypesPerSNP(SNPhood.o, regions = NULL, fileToPlot = NULL,
  returnOnlyPlotNotObject = FALSE, verbose = FALSE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{regions}{Numeric or Character or NULL. Default NULL. Regions that should be plotted, either specified as integer (such as 1, value must be
between 1 and the total number of regions as defined in the object) or their annotation (name must appear in the region names as obtained via the function \code{annotationRegions}). If set to NULL, all regions will be considered.}

\item{fileToPlot}{Character(1) or \code{NULL}. Default \code{NULL}. 
Filename of the PDF file for the output plots.
If set to \code{NULL}, plots will be plotted to the currently active device.}

\item{returnOnlyPlotNotObject}{Logical(1). Default FALSE. If set to TRUE, only the plots are returned but not the actual object. 
Otherwise, for consistancy among the various visualization functions, the \code{\linkS4class{SNPhood}}  object is always returned, while the plots are
either written to a PDF file as specified by the parameter \code{fileToPlot} and/or to the currently active graphics device (i.e., the console usually)}

\item{verbose}{Logical(1). Default FALSE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
the generated \pkg{ggplot2} plot(s) as list for further processing. May contain multiple plots, depending on the function. The plot(s) can then be plotted individually or modified arbitrarily as the user wants. For example, if multiple plots are returned and the plots have been saved in a variable called plots.l, simply type plots.l[[1]] to view the first plot.
}
\description{
Creates bar plots for the distribution of genotype frequencies of regions across individuals.
}
\examples{
data(SNPhood.o, package="SNPhood")
plot = plotGenotypesPerSNP(SNPhood.o, regions=1:20)
}
\seealso{
\code{\link{plotAndClusterMatrix}}
}

