% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plotGenotypesPerCluster}
\alias{plotGenotypesPerCluster}
\title{Visualize average counts/enrichment based on strong and weak genotypes.}
\usage{
plotGenotypesPerCluster(SNPhood.o, printBinLabels = TRUE, fileToPlot = NULL,
  printPlot = TRUE, returnOnlyPlotNotObject = FALSE, verbose = FALSE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{printBinLabels}{Logical(1). Default TRUE. Should the bin labels be printed? 
If multiple clusters are plotted simultaenously, bin labels might overlap, in which case \code{printBinLabels} can be set to FALSE.}

\item{fileToPlot}{Character(1) or \code{NULL}. Default \code{NULL}. 
Filename of the PDF file for the output plots.
If set to \code{NULL}, plots will be plotted to the currently active device.}

\item{printPlot}{Logical(1). Default TRUE. Should the plots be printed? Only relevant if \code{fileToPlot} is set to NULL; otherwise, the plots
are always printed to the output file.}

\item{returnOnlyPlotNotObject}{Logical(1). Default FALSE. If set to TRUE, only the plots are returned but not the actual object. 
Otherwise, for consistancy among the various visualization functions, the \code{\linkS4class{SNPhood}}  object is always returned, while the plots are
either written to a PDF file as specified by the parameter \code{fileToPlot} and/or to the currently active graphics device (i.e., the console usually)}

\item{verbose}{Logical(1). Default FALSE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
the generated \pkg{ggplot2} plot(s) as list for further processing. May contain multiple plots, depending on the function. The plot(s) can then be plotted individually or modified arbitrarily as the user wants. For example, if multiple plots are returned and the plots have been saved in a variable called plots.l, simply type plots.l[[1]] to view the first plot.
}
\description{
The function \code{plotGenotypesPerCluster} plots average clusters per genotype based on the clustering results of
the strong an weak genotype analysis (see \code{\link{plotAndCalculateWeakAndStrongGenotype}}), which has to be executed before.
}
\examples{
data(SNPhood.o, package="SNPhood")
SNPhood_merged.o = mergeReadGroups(SNPhood.o)
SNPhood_merged.o = plotAndCalculateWeakAndStrongGenotype(SNPhood_merged.o)
plot = plotGenotypesPerCluster(SNPhood_merged.o, printPlot = FALSE)
}
\seealso{
\code{\link{plotAndCalculateWeakAndStrongGenotype}}
}

