% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataClasses.R
\docType{methods}
\name{enrichment}
\alias{enrichment}
\alias{enrichment,SNPhood-method}
\title{Extract enrichment data from an object.}
\usage{
enrichment(object, ...)

\S4method{enrichment}{SNPhood}(object, readGroup = NULL, dataset = NULL,
  ...)
}
\arguments{
\item{object}{An object containing enrichment information.}

\item{...}{Additional arguments, for use in specific methods.}

\item{readGroup}{Character(1). Default NULL. Read group that should be plotted, specified by its name as obtained by the function \code{annotationReadGroups}). If only one read group is defined in the object, this may also be NULL for user conveniance.}

\item{dataset}{Numeric(1) or Character(1). Single dataset that should be used for plotting, either specified as integer (such as 1, value must be
between 1 and the total number of datasets as defined in the object) or its annotation (name must appear in the dataset names as obtained via the function \code{annotationDatasets}).}
}
\value{
Enrichment of the object or the objects components.

Named list with the requested enrichment matrices from the \code{\link{SNPhood}} object, organized by read group and dataset
}
\description{
Extract enrichment data from an object.

\code{enrichment} extracts enrichment data from a \code{\link{SNPhood}} object. The full count data or only a subset can be extracted 
by settings the parameters \code{type}, \code{readGroup} and \code{dataset} accordingly. Principally, either the count data
for the unbinned or binned SNP regions can be extracted.
}
\examples{
data(SNPhood.o, package="SNPhood")
str(enrichment(SNPhood.o), list.len=5)
}
\seealso{
\code{\link{counts}}
}

