% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{convertToAllelicFractions}
\alias{convertToAllelicFractions}
\title{Convert read counts across read groups to relative fractions from a \emph{SNPhood} object.}
\usage{
convertToAllelicFractions(SNPhood.o, roundDigits = 2, setNaNToZero = FALSE,
  verbose = TRUE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{roundDigits}{Numeric(1). Default 2. Number of digits after the decimal place when converting read counts to fractions}

\item{setNaNToZero}{Logical(1). Default FALSE. Should NaN (not a number) be converted to 0? NaN may result from individual regions or 
bins with no reads across all read groups due to a division by zero.}

\item{verbose}{Logical(1). Default TRUE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
an object of class \code{\link{SNPhood}} with read counts across read groups (both for the slots readCountsUnbinned and 
readCountsBinned) replaced by their respective relative fractions. Otherwise identical to the input \code{\link{SNPhood}} object.
}
\description{
\code{convertToAllelicFractions} convert read counts across read groups to their relative fractions among all 
read groups (all read counts will be between 0 and 1, with 1 for a particular read group depicting that all reads 
from this particular position originate from the one read group)
Affected slots are \code{readCountsUnbinned} and \code{readCountsBinned}. 
It is recommended to save the resulting \code{\link{SNPhood}} object with a new name because it is not possible to go back from 
fractions to read counts at a later point.
}
\examples{
data(SNPhood.o, package="SNPhood")
SNPhood_allelicFractions.o = convertToAllelicFractions(SNPhood.o)

# Convert all NaN to 0 for subsequent analyses
SNPhood_allelicFractions.o = convertToAllelicFractions(SNPhood.o, setNaNToZero = TRUE)

}
\seealso{
\code{\link{deleteReadGroups}}
}

