% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{annotationBins2}
\alias{annotationBins2}
\title{Get the annotation(names) of bins in a \emph{SNPhood} object.}
\usage{
annotationBins2(SNPhood.o, regions = NULL, fullAnnotation = FALSE,
  verbose = TRUE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{regions}{Integer or character. Default NULL. A subset of the SNP regions for which annotation is needed. Either the row numbers or the rownames(IDs) of the SNP regions are supported.}

\item{fullAnnotation}{Logical(1). Should the full annotation(as a data.frame) be returned or only the annotation of the bins(as a character vector)?}

\item{verbose}{Logical(1). Default TRUE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
If \code{fullAnnotation} is set to \code{TRUE}, a data.frame with the full annotation of the bins for the(subset of) SNP regions is returned. Otherwise, a character vector with only the annotation of the bins is returned.
}
\description{
\code{annotationBins2} is a helper function that returns annotation of the bins that are defined in the \code{\linkS4class{SNPhood}} object.
}
\section{Warning}{

\strong{The number of returned bins can easily be very large, in the order of millions.
Be careful because the memory consumption due the resulting object may increase considerably.} 
Reduce memory requirements by returning only a subset of SNP regions
}
\examples{
data(SNPhood.o, package="SNPhood")
annotation.df  = annotationBins2(SNPhood.o, regions = 1:10, fullAnnotation = TRUE)
annotation.vec = annotationBins2(SNPhood.o, regions = 1:10, fullAnnotation = FALSE)
}

