% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataClasses.R
\docType{class}
\name{SNPhood-class}
\alias{SNPhood-class}
\title{A class to represent, investigate, quantify and visualise the epigenomic neighbourhood of SNPs using NGS data}
\description{
The class \code{SNPhood} stores read count-derived information from NGS files for a set of genomic regions of interest as well as associated metadata. 
It may additionally contain results of various subsequent analyses and statistical tests. 
See the description below or the Vignette for more details.
}
\section{Slots}{

\describe{
\item{\code{annotation}}{Named list. Contains various annotation and metadata such as:
\itemize{ 
\item \code{regions}: An object of class \code{GenomicRanges} that contains the user regions, including annotation and the position 
of the original user-provided position before creating regions and bins.  
\item \code{genotype}: A list one or two elements, both of which contain genotype-related information, either directly from the sequencing reads
or externally derived from a VCF file using the function \code{\link{associateGenotypes}}.
\item \code{readGroups}: The names of the read groups that are currently defined.
\item \code{files}: Contains a named list with additional information about each processed file, such as type(\code{signal} or \code{input}), \code{files}(a vector of one or multiple filenames), and \code{composite}(\code{TRUE} or \code{FALSE}, indicating if this is a composite file from multiple individual files)
}
Elements from this slot can be retrieved with the accessor function \code{\link{annotation}}.}

\item{\code{config}}{Named list. Named list with the parameters as specified in the parameter list and additionally the specific parameters
the function \code{\link{analyzeSNPhood}} was called with (such as \code{onlyPrepareForDatasetCorrelation} and \code{input}). Elements from
this slot can be retrieved with the accessor function \code{\link{parameters}}.}

\item{\code{readCountsUnbinned}}{Named list (nested). Contains vectors of raw reads counts for each user region (before binning). 
The names of the list are the read groups and the filenames of the annotated datasets. Elements from
 this slot can be retrieved with the accessor function \code{\link{counts}} using \code{type} = "unbinned".}

\item{\code{readCountsBinned}}{Named list (nested). Each element contains a matrix of raw reads counts per user region and bin (i.e., after binning). 
 The names of the list are the read groups and the filenames of the annotated datasets. 
Contains the raw read counts if normalization among all datasets ha sbeen performed (parameter \code{normAmongEachOther} is set to FALSE)
and normalized read counts otherwise.\cr \cr 
If read counts are recorded allele-specifically (in the following snippet paternal, maternal and ambiguous) for each group, 
the structure therefore may look like this:
\itemize{
\item \code{paternal}:
 \itemize{
 \item \code{dataset ID 1}: Matrix of read counts for each user region across bins
 \item \code{dataset ID 2}: Matrix of read counts for each user region across bins
 \item ...
 }
\item \code{maternal}: See read group paternal, identical structure
\item \code{ambiguous}: See read group paternal, identical structure
}}

\item{\code{enrichmentBinned}}{Named list. See the description for the slot \code{readCountsBinned}, 
with the only difference that this slot contains the enrichment after normalizing with an input rather than the read counts. 
If input normalization is turned off, this slot is empty.}

\item{\code{additionalResults}}{Named list. Contains additional information from subsequent analyses such as allelic bias tests or results 
of the genotype analysis. Initially empty. Different functions write the results in this slot. 
Elements from this slot can be retrieved with the accessor function \code{\link{results}}.}
}}
\section{Constructors}{

Currently, a \code{SNPhood} object can only be constructed by executing the main function of the package, \code{\link{analyzeSNPhood}}.
}

\section{Accessors}{

In the following code snippets, \code{SNPhood.o} is a \code{SNPhood} object and
\code{readGroupCur} and \code{datasetCur} a particular read group and dataset as defined in \code{SNPhood.o}, respectively.

# Get general annotation of a SNPhood object

\code{annotation(SNPhood.o)}: Get the annotation information, a nested list with multiple components (see names(annotation(SNPhood.o))).

# Get more specific annotation such as number and annotation of regions, datasets, bins, and read groups

\code{nRegions(SNPhood.o)}: Get the number of user regions.

\code{nDatasets(SNPhood.o)}: Get the number of datasets.

\code{nBins(SNPhood.o)}: Get the number of bins.

\code{nReadGroups(SNPhood.o)}: Get the number of read groups.

\code{annotationRegions(SNPhood.o)}: Get the annotation of user regions. 

\code{annotationDatasets(SNPhood.o)}: Get the annotation of datasets. 

\code{annotationBins(SNPhood.o)}: Get the annotation of bins. 

\code{annotationReadGroups(SNPhood.o)}: Get the annotation of read groups. 

# Get the parameters that were used for the analysis

\code{parameters(SNPhood.o)}: Get the parameter information, a nested list with multiple components (see names(parameters(SNPhood.o))).

# Get counts before binning 

\code{counts(SNPhood.o, type = "unbinned", readGroup = readGroupCur, dataset = datasetCur)}: Get the counts for each user region before binning.
See ?counts for more details.

# If applicable, get counts after binning

\code{counts(SNPhood.o, type = "binned", readGroup = readGroupCur, dataset = datasetCur)}: Get the counts for each user region after binning.
See ?counts for more details.

# If applicable, get enrichment after binning

\code{enrichment(SNPhood.o, type = "binned", readGroup = readGroupCur, dataset = datasetCur)}: Get the enrichment for each user region after binning.
See ?enrichment for more details.

\strong{In addition, see the workflow vignette (browseVignettes(\"SNPhood\") for a full workflow that uses all accessors.}
}
\keyword{SNPhood}
\keyword{SNPhood-class,}

