% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompPASS.R
\name{CompPASS}
\alias{CompPASS}
\title{CompPASS}
\usage{
CompPASS(datInput)
}
\arguments{
\item{datInput}{A dataframe with column names: idRun, idBait, idPrey, 
countPrey. Each row represent one unique protein captured in one 
pull-down experiment}
}
\value{
A data frame consists of unique bait-prey pairs with 
Z-score, S-score,D-score and WD-score indicating interacting probabilities.
}
\description{
CompPASS
Comparative Proteomic Analysis Software Suite (CompPASS) is based on spoke
model. This algorithm was developed by Dr. Mathew Sowa for defining the
human deubiquitinating enzyme interaction landscape
(Sowa, Mathew E., et al., 2009). The implementation of this algorithm was
inspired by Dr. Sowa's online tutorial
(\url{http://besra.hms.harvard.edu/ipmsmsdbs/cgi-bin/tutorial.cgi}).
The output includes Z-score, S-score, D-score and WD-score.
This function also computes entropy and normalized 
WD-score. The source  code for this function was based on the source code. 
 \url{https://github.com/dnusinow/cRomppass}
}
\examples{
data(TestDatInput)
datScore <- CompPASS(TestDatInput)
head(datScore)
}
\references{
Sowa, Mathew E., et al. "Defining the human deubiquitinating
enzyme interaction landscape." Cell 138.2 (2009): 389-403.
\url{https://doi.org/10.1016/j.cell.2009.04.042}

Huttlin, Edward L., et al. "The BioPlex network: a systematic 
exploration of the human interactome." Cell 162.2 (2015): 425-440. 
\url{https://doi.org/10.1016/j.cell.2015.06.043}

Huttlin, Edward L., et al. "Architecture of the human 
interactome defines protein communities and disease networks." 
Nature 545.7655 (2017): 505. 
\url{https://www.nature.com/articles/nature22366}
}
\author{
Qingzhou Zhang, \email{zqzneptune@hotmail.com}
}
