\name{sim.plot.overlapping.indep.dep.features}

\alias{sim.plot.overlapping.indep.dep.features}

\title{P-value plot and mean-zscore plots with indication of overlapping features.}

\description{	
	Generates three plots:
		The first plot contains the P-values along the region, with the cut-off displayed.
  		The second plot contains the mean-zscores along the region, with the cut-offs displayed.
		The third plots generates the cytobands of the region.
}

\usage{
sim.plot.overlapping.indep.dep.features(input.regions, 
input.region.indep = NULL,
adjust.method = "BY", 
log = FALSE,                                      
significance = 0.2,
max.pow = 5, 
z.threshold = c(-3,3), 
summarize = c("consecutive", "stretch", "window"),
stretch = 10,
window = 1e6,
percentage = 0.5,
xlim=NULL,
pdf = FALSE,
method = c("full", "smooth", "window", "overlap"), 
run.name = "analysis_results", ...)
}

\arguments{
	\item{input.regions}{\code{vector} indicating the dependent regions to be analyzed. Can be defined in four ways:
  	      \code{1) predefined input region: } insert a predefined input region, choices are: 
  	      \dQuote{all chrs}, 
  	      \dQuote{all chrs auto}, 
  	      \dQuote{all arms}, 
  	      \dQuote{all arms auto} 
  	      In the predefined regions \dQuote{all arms} and \dQuote{all arms auto} the arms 13p, 14p, 15p, 21p and 22p 
  	      are left out, because in most studies there are no or few probes in these regions. 
  	      To include them, just make your own vector of arms. 
  	      \code{2) whole chromosome(s): } insert a single chromosome or a list of chromosomes as a 
  	      \code{vector:} 
  	      \code{c(1, 2, 3)}. 
  	      \code{3) chromosome arms: } insert a single chromosome arm  or a list of chromosome arms like 
  	      \code{c("1q", "2p", "2q")}.
  	      \code{4) subregions of a chromosome: } insert a chromosome number followed by the start and end position like 
  	      \code{"chr1:1-1000000"} 
  	      These regions can also be combined, e.g. \code{c("chr1:1-1000000","2q", 3)}. 
  	      See \code{\link{integrated.analysis}} for more information.}
	  
  	\item{input.region.indep}{indicating the independent region which will be analysed in combination of the dependent 
                              region. Only one input region can given using the same format as the dependent input region.}
  	
  	\item{adjust.method}{Method used to adjust the P-values for multiple testing, see \link[stats:p.adjust]{p.adjust}.
         Default is \dQuote{BY} recommended when copy number is used as dependent data. 
         See \link{SIM} for more information about adjusting P-values.}

 	\item{log}{\code{logical} default \code{log = FALSE}, if \code{log = TRUE} P-values are plotting on \eqn{log[10]} scale.}
  
	\item{significance}{The threshold for selecting significant P-values.}
	
	\item{max.pow}{\code{numeric} only when \code{log = TRUE} scale of the y-axis.}
	
	\item{z.threshold}{Threshold to display a green or red bar in the color bar on top of 
                       the heatmap for independent features with mean z-scores above \code{z.threshold} (high positive 
                       association) or below \code{-z.threshold} (high negative association).}
	
	\item{summarize}{either one of \dQuote{consecutive}, \dQuote{stretch}, \dQuote{window} which visualizes the subregions according to
	                the selected summarization a) \dQuote{consecutive} shows the consecutive significant regions b) \dQuote{stretch} shows
	                a percentage \code{percentage} significant stretch of size \code{stretch}} and c) \dQuote{window} a percentage \code{percentage} 
	                significant window of length \code{window}
	
	\item{stretch}{\code{integer} length of stretch, default \code{stretch = 10}}
	
	\item{window}{\code{integer} length of window, default \code{window = 1e6}}
	
	\item{percentage}{\code{numeric} a number between \eqn{[0,1]} given the percentage of significance in either the \dQuote{stretch} of \dQuote{window}}
	
	\item{xlim}{\code{c(min, max)} scale of the x-axis. Can be used for zooming in on a region.}
	
	\item{pdf}{\code{logical} indicate whether to generate a pdf of the plots in the current working directory or not.}
	 
	\item{method}{this must be the either full, window, overlap or smooth but the data should generated by the 
         same method in \code{integrated.analysis}.}
	
	\item{run.name}{This must be the same a given to \code{integrated.analysis}}
	
	\item{...}{not used in this version}
}
\details{
	details: Cytobands plot adapted from SNPChip
}

\value{
	No values are returned.The results are stored in a subdirectory of \code{run.name} as pdf.}

\author{Marten Boetzer, Melle Sieswerda, Renee X. de Menezes  \email{R.X.Menezes@lumc.nl}}

\seealso{
\link{SIM}, 
\link{tabulate.top.dep.features}, 
\link{tabulate.top.indep.features}, 
\link{getoverlappingregions}
}

\examples{
#first run example(assemble.data)
#and example(integrated.analysis)
#overview plot of the dependent and independent features
sim.plot.overlapping.indep.dep.features(input.regions="8q", 
		                                adjust.method="BY", 
										significance=0.1, 
										z.threshold= c(-1,1),
										log=TRUE,	
										summarize="consecutive",
										pdf=FALSE, 
										method="full",
										run.name="chr8q") 
}

\keyword{hplot}

