% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emalgth.R
\name{emalgth}
\alias{emalgth}
\title{Calculate the probability on condition that the sums equal to 1.}
\usage{
emalgth(X)
}
\arguments{
\item{X}{A matrix about X, the elements in X takes values on {0,1} and
satisfy the sums of each row equal to 1.}
}
\value{
y1 The probability when sums equal to 1.
}
\description{
Calculate the probability on condition that only a single CpG 
contributes to a short read.
}
\examples{
set.seed(123)
d <- matrix(0, nrow=200, ncol=50)
random_num <- sample(1:50, 200, replace=TRUE)
for(i in 1:nrow(d)){
    d[i,random_num[i]]<-1
}
result <- emalgth(d)
head(result)
}
