% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siamcat_class_accessors.R
\docType{methods}
\name{weight_matrix}
\alias{weight_matrix}
\alias{weight_matrix,siamcat-method}
\title{Retrieve the weight matrix from a SIAMCAT object}
\usage{
weight_matrix(siamcat, verbose=1)

\S4method{weight_matrix}{siamcat}(siamcat, verbose = 1)
}
\arguments{
\item{siamcat}{(Required). An instance of \link{siamcat-class}
that contains trained models}

\item{verbose}{integer, if the slot is empty, should a message be printed?
values can be either \code{0} (no output) or \code{1} (print message)}
}
\value{
A matrix containing the feature weights or \code{NULL}
}
\description{
Function to retrieve the feature weights from a SIAMCAT object
}
\details{
The function extracts the feature weights from all trained models
acorss all cross-validation folds and repeats.
}
\examples{
data(siamcat_example)
temp <- weight_matrix(siamcat_example)
temp[1:3, 1:3]
}
