% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siamcat_class_accessors.R
\docType{methods}
\name{pred_matrix}
\alias{pred_matrix}
\alias{pred_matrix,siamcat-method}
\title{Retrieve the prediction matrix from a SIAMCAT object}
\usage{
pred_matrix(siamcat, verbose=1)

\S4method{pred_matrix}{siamcat}(siamcat, verbose = 1)
}
\arguments{
\item{siamcat}{(Required). A \link{siamcat-class} object
that contains a prediction matrix}

\item{verbose}{integer, if the slot is empty, should a message be printed?
values can be either \code{0} (no output) or \code{1} (print message)}
}
\value{
A matrix containing predictions or \code{NULL}
}
\description{
Function to retrieve the prediction matrix from a SIAMCAT
object
}
\details{
The functions returns a matrix containing the predictions for all
samples across the different cross-validation repeats. See
\link{make.predictions} for more information.
}
\examples{
data(siamcat_example)
temp <- pred_matrix(siamcat_example)
head(temp)
}
