% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siamcat_class_accessors.R
\docType{methods}
\name{norm_params}
\alias{norm_params}
\alias{norm_params,siamcat-method}
\title{Retrieve the list of parameters for feature normalization from a
SIAMCAT object}
\usage{
norm_params(siamcat, verbose=1)

\S4method{norm_params}{siamcat}(siamcat, verbose = 1)
}
\arguments{
\item{siamcat}{(Required). An instance of \link{siamcat-class}
containing normalized features}

\item{verbose}{integer, if the slot is empty, should a message be printed?
values can be either \code{0} (no output) or \code{1} (print message)}
}
\value{
A list of normalization parameters or \code{NULL}
}
\description{
Function to retrieve the list of parameters for feature
normalization
}
\details{
The function returns the list of normalization parameters used in
the feature normalization procedure. See \link{normalize.features} for
more details.
}
\examples{
data(siamcat_example)
temp <- norm_params(siamcat_example)
names(temp)
}
