% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siamcat_class_accessors.R
\docType{methods}
\name{model_type}
\alias{model_type}
\alias{model_type,siamcat-method}
\title{Retrieve the machine learning method from a SIAMCAT object}
\usage{
model_type(siamcat, verbose=1)

\S4method{model_type}{siamcat}(siamcat, verbose = 1)
}
\arguments{
\item{siamcat}{(Required). An instance of \link{siamcat-class}
that contains trained models}

\item{verbose}{integer, if the slot is empty, should a message be printed?
values can be either \code{0} (no output) or \code{1} (print message)}
}
\value{
The string describing the machine learning method or \code{NULL}
}
\description{
Function to retrieve information on which type of machine
learning method was used for model training
}
\details{
The function extracts the information on which type of machine
learning method was used for model training.
}
\examples{
data(siamcat_example)
model_type(siamcat_example)
}
