% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siamcat_class_accessors.R
\docType{methods}
\name{feature_type}
\alias{feature_type}
\alias{feature_type,siamcat-method}
\title{Retrieve the feature type used for model training from a SIAMCAT
object}
\usage{
feature_type(siamcat, verbose=1)

\S4method{feature_type}{siamcat}(siamcat, verbose = 1)
}
\arguments{
\item{siamcat}{(Required). An instance of \link{siamcat-class}
that contains trained models}

\item{verbose}{integer, if the slot is empty, should a message be printed?
values can be either \code{0} (no output) or \code{1} (print message)}
}
\value{
The string describing type of feature used for the model training
or \code{NULL}
}
\description{
Function to retrieve information on which type of features the
models were trained
}
\details{
The function extracts the information on which type of features
the models were trained.
}
\examples{
data(siamcat_example)
feature_type(siamcat_example)
}
