% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_data_split.r
\encoding{UTF-8}
\name{create.data.split}
\alias{create.data.split}
\title{Split a dataset into training and a test sets.}
\usage{
create.data.split(siamcat, num.folds = 2, num.resample = 1, 
stratify = TRUE, inseparable = NULL, verbose = 1)
}
\arguments{
\item{siamcat}{object of class \link{siamcat-class}}

\item{num.folds}{integer number of cross-validation folds (needs to be 
\code{>=2}), defaults to \code{2}}

\item{num.resample}{integer, resampling rounds (values \code{<= 1} 
deactivate resampling), defaults to \code{1}}

\item{stratify}{boolean, should the splits be stratified so that an equal 
proportion of classes are present in each fold?, will be ignored for 
regression tasks, defaults to \code{TRUE}}

\item{inseparable}{string, name of metadata variable to be inseparable,
defaults to \code{NULL}, see Details below}

\item{verbose}{integer, control output: \code{0} for no output at all, 
\code{1} for only information about progress and success, \code{2} for
normal level of information and \code{3} for full debug information,
defaults to \code{1}}
}
\value{
object of class \link{siamcat-class} with the \code{data_split}-slot
filled
}
\description{
This function prepares the cross-validation by splitting the 
data into \code{num.folds} training and test folds for 
\code{num.resample} times.
}
\details{
This function splits the labels within a \link{siamcat-class} 
object and prepares the internal cross-validation for the model training 
(see \link{train.model}). 

The function saves the training and test instances for the different 
cross-validation folds within a list in the \code{data_split}-slot of the 
\link{siamcat-class} object, which is a list with four entries: \itemize{ 
\item \code{num.folds} - the number of cross-validation folds
\item \code{num.resample} - the number of repetitions for the 
cross-validation
\item \code{training.folds} - a list containing the indices for the 
training instances
\item \code{test.folds} - a list containing the indices for the 
test instances }

If provided, the data split will take into account a metadata variable
for the data split (by providing the \code{inseparable} argument). For
example, if the data contains several samples for the same individual,
it makes sense to keep data from the same individual within the
same fold.

If \code{inseparable} is given, the \code{stratify} argument will be
ignored.
}
\examples{
data(siamcat_example)

# simple working example
siamcat_split <- create.data.split(siamcat_example, num.folds=10, 
num.resample=5, stratify=TRUE)
}
\keyword{SIAMCAT}
\keyword{create.data.split}
