% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlaps.R
\name{splicesiteOverlap}
\alias{splicesiteOverlap}
\title{Compatible fragment counts for splice sites}
\usage{
splicesiteOverlap(splicesites, side, frag_exonic, frag_intron, min_anchor,
  include = c("all", "spliced", "unspliced"), counts = TRUE)
}
\arguments{
\item{splicesites}{\code{IRanges} of splice sites}

\item{side}{Character vector indicating whether the spliced boundary
is to the left (\dQuote{L}) or right (\dQuote{R}) of the splice site}

\item{frag_exonic}{\code{IRangesList} of exonic regions, one entry
per fragment}

\item{frag_intron}{\code{IRangesList} of introns, one entry per fragment}

\item{min_anchor}{Integer specifiying minimum anchor length}

\item{include}{Character string indicating whether considered fragments
should be all that overlap the splice site (\dQuote{all}), those
that are spliced at the site (\dQuote{spliced}) or those that are
not spliced, i.e. extend into the adjacent intron (\dQuote{unspliced})}

\item{counts}{Logical indicating whether counts or indices of
compatible fragments should be returned}
}
\value{
Counts or list of indices of compatible fragments
}
\description{
Identify fragments with alignments extending across exon/intron boundaries.
}
\author{
Leonard Goldstein
}
\keyword{internal}
