% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-prediction.R
\name{predictExonsTerminal}
\alias{predictExonsTerminal}
\title{Identify terminal exons}
\usage{
predictExonsTerminal(candidates, frag_exonic, frag_intron, relCov, min_anchor,
  type = c("exon_L", "exon_R"), include_counts, retain_coverage)
}
\arguments{
\item{candidates}{\code{IRanges} of candidate internal exons}

\item{frag_exonic}{\code{IRangesList} with exonic regions from alignments}

\item{frag_intron}{\code{IRangesList} with introns implied by spliced
alignments}

\item{relCov}{Minimum relative coverage required for exon prediction}

\item{min_anchor}{Integer specifiying minimum anchor length}

\item{type}{Character string indicating whether terminal exons
should be identified to the left (\dQuote{exon_L}) or right
(\dQuote{exon_R}) of provided splice sites}

\item{include_counts}{Logical indicating whether counts of
compatible fragments should be included in metadata column
\dQuote{N}}

\item{retain_coverage}{Logical indicating whether coverage for each
exon should be retained as an \code{RleList} in metadata
column \dQuote{coverage}. This allows filtering of features
using more stringent criteria after the initial prediction.}
}
\value{
\code{IRanges} of terminal exons with metadata column
  \dQuote{type} and optionally \dQuote{N} for
  \code{include_counts = TRUE}, \dQuote{N_splicesite},
  \dQuote{coverage} for \code{retain_coverage = TRUE}
}
\description{
Identify terminal exons based on candidate terminal exons and
compatible read coverage.
}
\author{
Leonard Goldstein
}
\keyword{internal}
