% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotFeatures}
\alias{plotFeatures}
\title{Plot splice graph and heatmap of expression values}
\usage{
plotFeatures(x, geneID = NULL, geneName = NULL, which = NULL,
  tx_view = FALSE, cex = 1, assay = "FPKM", include = c("junctions",
  "exons", "both"), transform = function(x) {     log2(x + 1) },
  Rowv = NULL, distfun = dist, hclustfun = hclust, margin = 0.2,
  RowSideColors = NULL, square = FALSE, cexRow = 1, cexCol = 1,
  labRow = colnames(x), col = colorRampPalette(c("black", "gold"))(256),
  zlim = NULL, heightPanels = c(1, 2), ...)
}
\arguments{
\item{x}{\code{SGFeatureCounts} object}

\item{geneID}{Single gene identifier used to subset \code{x}}

\item{geneName}{Single gene name used to subset \code{x}}

\item{which}{\code{GRanges} used to subset \code{x}}

\item{tx_view}{Plot transcripts instead of splice graph (experimental)}

\item{cex}{Scale parameter for feature labels and annotation}

\item{assay}{Name of assay to be plotted in the heatmap}

\item{include}{Include \dQuote{exons}, \dQuote{junctions} or
\dQuote{both} in the heatmap}

\item{transform}{Transformation applied to assay data}

\item{Rowv}{Determines order of rows. Either a vector of values used to
reorder rows, or \code{NA} to suppress reordering, or \code{NULL} for
hierarchical clustering.}

\item{distfun}{Distance function used for hierarchical clustering
of rows (samples)}

\item{hclustfun}{Clustering function used for hierarchical clustering
of rows (samples)}

\item{margin}{Width of right-hand margin as fraction of width of the
graphics device. Ignored if \code{square} is \code{TRUE}.}

\item{RowSideColors}{Character vector (or list of character vectors)
with length(s) equal to \code{ncol(x)} containing color names for
horizontal side bars for sample annotation}

\item{square}{Logical, if \code{TRUE} margins are set such that
cells in the heatmap are square}

\item{cexRow}{Scale factor for row (sample) labels}

\item{cexCol}{Scale factor for column (feature) labels}

\item{labRow}{Character vector of row (sample) labels}

\item{col}{Heatmap colors}

\item{zlim}{Range of values for which colors should be plotted,
if \code{NULL} range of finite values}

\item{heightPanels}{Numeric vector of length two indicating height of
the top and bottom panels.}

\item{...}{further arguments passed to \code{plotSpliceGraph}}
}
\value{
\code{data.frame} with information on exon bins and
  splice junctions included in the splice graph
}
\description{
Plot splice graph and heatmap of expression values.
}
\examples{
\dontrun{
sgfc_annotated <- annotate(sgfc_pred, txf_ann)
plotFeatures(sgfc_annotated)
}
NULL
}
\author{
Leonard Goldstein
}
