% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-filter.R
\name{filterFeatures}
\alias{filterFeatures}
\title{Filter predicted features}
\usage{
filterFeatures(features, paired_end, read_length, frag_length, lib_size,
  min_junction_count = NULL, alpha, psi, beta, gamma)
}
\arguments{
\item{features}{\code{TxFeatures} object with predicted features,
including metadata columns \dQuote{N}, \dQuote{N_splicesite} and
\dQuote{coverage}.}

\item{paired_end}{Logical, \code{TRUE} for paired-end data,
\code{FALSE} for single-end data}

\item{read_length}{Read length required for use with \code{alpha}}

\item{frag_length}{Fragment length for paired-end data required
for use with \code{alpha}}

\item{lib_size}{Number of aligned fragments required for use with
\code{alpha}}

\item{min_junction_count}{Minimum fragment count required for a splice
junction to be included. If specified, argument \code{alpha} is ignored.}

\item{alpha}{Minimum FPKM required for a splice junction to be
included. Internally, FPKMs are converted to counts, requiring arguments
\code{read_length}, \code{frag_length} and \code{lib_size}.
\code{alpha} is ignored if argument \code{min_junction_count}
is specified.}

\item{psi}{Minimum splice frequency required for a splice junction
to be included}

\item{beta}{Minimum relative coverage required for an internal exon
to be included}

\item{gamma}{Minimum relative coverage required for a terminal exon
to be included}
}
\value{
\code{TxFeatures} object with filtered features
}
\description{
Filter previously predicted features using more stringent criteria.
}
\details{
Initial predictions with \code{predictTxFeatures} must have been performed
with \code{include_counts = TRUE} and \code{retain_coverage = TRUE},
so that predicted features contain metadata columns \dQuote{N},
\dQuote{N_splicesite} and \dQuote{coverage}.
}
\author{
Leonard Goldstein
}
\keyword{internal}
