% SGCP_ezPLOT
\name{SGCP_ezPLOT}
\alias{SGCP_ezPLOT}
\title{Comprehensive SGCP plotting in one execution}
\description{
The plotting function for ezSGCP results visualizes various aspects. It accepts the ezSGCP output and expression data, generating the following plots: PCA of transformed and expression data, cluster conductance, gene silhouette index, method for determining the number of clusters, distribution and density of gene ontology terms, and cluster performance metrics for both initial clusters and final modules.
}
\usage{
    SGCP_ezPLOT(sgcp, expreData, keep = FALSE,
            pdf.file = TRUE, pdfname = "ezSGCP.pdf",
            excel.file = TRUE, xlsxname = "ezSGCP.xlsx",
            w = 6, h = 6, sr = 2, sc = 2, ftype = "png",  uni = "in",
            expressionPCA = TRUE, pointSize1 = .5,
            exprePCATitle0 = "Expression Data PCA Without Labels",
            exprePCATitle1 = "Expression Data PCA With Initial Labels",
            exprePCATitle2 = "Expression Data PCA With Final Labels",
            transformedPCA = TRUE, pointSize2 = 0.5,
            transformedTitle0 = "Transformed Data PCA Without Labels",
            transformedTitle1 = "Transformed Data PCA Initial Labels",
            transformedTitle2 = "Transformed Data PCA Final Labels",
            conduct = TRUE,
            conductanceTitle = "Cluster Conductance Index",
            conductx = "clusterLabel", conducty = "conductance index",
            clus_num = TRUE,
            silhouette_index = FALSE,
            silTitle = "Gene Silhouette Index",
            silx = "genes", sily = "silhouette index",
            jitt1 = TRUE,
            jittTitle1 = "Initial GO p-values", jps1 = 3,
            jittx1 = "cluster", jitty1 = "-log10 p-value",
            jitt2 = TRUE,
            jittTitle2 = "Final GO p-values", jps2 = 3,
            jittx2 = "module", jitty2 = "-log10 p-value",
            density1 = TRUE,
            densTitle1 = "Initial GO p-values Density",
            densx1 = "cluster", densy1 = "-log10 p-value",
            density2 = TRUE,
            densTitle2 = "Final GO p-values Density",
            densx2 = "module", densy2 = "-log10 p-value",
            mean1 = TRUE,
            meanTitle1 = "Cluster Performance",
            meanx1 = "cluster", meany1 = "mean -log10 p-value",
            mean2 = TRUE,
            meanTitle2 = "Module Performance",
            meanx2 = "module", meany2 = "mean -log10 p-value",
            pie1 = TRUE, pieTitle1 = "Initial GO Analysis",
            piex1 = "cluster", piey1 = "count", posx1 = 1.8,
            pie2 = TRUE, pieTitle2 = "Final GO Analysis",
            piex2 = "module", piey2 = "count", posx2 = 1.8)
}
\arguments{
    \item{sgcp}{Result from the SGCP pipeline, typically generated by the ezSGCP function.}
    \item{expreData}{Matrix containing the initial gene expression dataset.}
    \item{keep}{Logical, default \code{FALSE}. If \code{TRUE}, retains plotting objects.}
    \item{pdf.file}{Logical, default \code{TRUE}. If \code{TRUE}, saves plots in a PDF file.}
    \item{pdfname}{Character string, default "ezSGCP.pdf", name of the PDF file for plots.}
    \item{excel.file}{Logical, default \code{TRUE}. If \code{TRUE}, saves plots in an Excel file.}
    \item{xlsxname}{Character string, default "ezSGCP.xlsx", name of the Excel file for plots.}
    \item{w}{Numeric, width of plot images in Excel, default 6.}
    \item{h}{Numeric, height of plot images in Excel, default 6.}
    \item{sr}{Numeric, starting row in the Excel sheet, default 2.}
    \item{sc}{Numeric, starting column in the Excel sheet, default 2.}
    \item{ftype}{Character string, plot image type, default "png".}
    \item{uni}{Character string, plot image units, default "in" for inches.}

    \item{expressionPCA}{Logical, default \code{TRUE}. If \code{TRUE}, plots PCA of gene expression data.}
    \item{pointSize1}{Numeric, point size for expression PCA, default 0.5.}

    \item{exprePCATitle0}{Character string, title for expression PCA plot without labels, default "Expression Data PCA Without Labels".}

    \item{exprePCATitle1}{Character string, title for expression PCA plot with initial cluster labels, default "Expression Data PCA With Initial Labels".}

    \item{exprePCATitle2}{Character string, title for expression PCA plot with final module labels, default "Expression Data PCA With Final Labels".}

    \item{transformedPCA}{Logical, default \code{TRUE}. If \code{TRUE}, plots PCA of transformed data.}
    \item{pointSize2}{Numeric, point size for transformed PCA, default 0.5.}

    \item{transformedTitle0}{Character string, title for PCA plot without labels on transformed data, default "Transformed Data PCA Without Labels".}

    \item{transformedTitle1}{Character string, title for PCA plot with initial cluster labels on transformed data, default "Transformed Data PCA Initial Labels".}

    \item{transformedTitle2}{Character string, title for PCA plot with final labels on transformed data, default "Transformed Data PCA Final Labels".}

    \item{conduct}{Logical, default \code{TRUE}. If \code{TRUE}, plots conductance indices for clusters.}
    \item{conductanceTitle}{Character string, title for conductance indices plot, default "Cluster Conductance Index".}
    \item{conductx}{Character string, x-axis title in conductance indices plot, default "clusterLabel".}
    \item{conducty}{Character string, y-axis title in conductance indices plot, default "conductance index".}

    \item{clus_num}{Logical, default \code{TRUE}. If \code{TRUE}, plots cluster number selection methods.}

    \item{silhouette_index}{Logical, default \code{FALSE}. If \code{TRUE}, plots silhouette indices for genes.}
    \item{silTitle}{Character string, title for silhouette indices plot, default "Gene Silhouette Index".}
    \item{silx}{Character string, x-axis title in silhouette plot, default "genes".}
    \item{sily}{Character string, y-axis title in silhouette indices plot, default "silhouette index".}


    \item{jitt1}{Logical, default \code{TRUE}. If \code{TRUE}, plots jitter plot of -log10 p-values of GO terms in initial clusters.}
    \item{jps1}{Numeric, point size in jitter plot for initial clusters, default 3.}
    \item{jittTitle1}{Character string, title for jitter plot for initial clusters, default "Initial GO p-values".}
    \item{jittx1}{Character string, legend for jitter plot for initial clusters, default "cluster".}
    \item{jitty1}{Character string, y-axis title in jitter plot for initial clusters, default "-log10 p-value".}

    \item{jitt2}{Logical, default \code{TRUE}. If \code{TRUE}, plots jitter plot of -log10 p-values of GO terms in final modules.}
    \item{jps2}{Numeric, point size in jitter plot for final modules, default 3.}
    \item{jittTitle2}{Character string, title for jitter plot for final modules, default "Final GO p-values".}
    \item{jittx2}{Character string, legend for jitter plot for final modules, default "module".}
    \item{jitty2}{Character string, y-axis title in jitter plot for final modules, default "-log10 p-value".}

    \item{density1}{Logical, default \code{TRUE}. If \code{TRUE}, plots density plot of p-values of GO terms in initial clusters.}
    \item{densTitle1}{Character string, title for density plot for initial clusters, default "Initial GO p-values Density".}
    \item{densx1}{Character string, legend for density plot for initial clusters, default "cluster".}
    \item{densy1}{Character string, y-axis title in density plot for initial clusters, default "-log10 p-value".}

    \item{density2}{Logical, default \code{TRUE}. If \code{TRUE}, plots density plot of p-values of GO terms in final modules.}
    \item{densTitle2}{Character string, title for density plot for final modules, default "Final GO p-values Density".}
    \item{densx2}{Character string, legend for density plot for final modules, default "module".}
    \item{densy2}{Character string, y-axis title in density plot for final modules, default "-log10 p-value".}

    \item{mean1}{Logical, default \code{TRUE}. If \code{TRUE}, plots mean over p-values of GO terms in initial clusters.}
    \item{meanTitle1}{Character string, title for mean plot for initial clusters, default "Cluster Performance".}
    \item{meanx1}{Character string, legend for mean plot for initial clusters, default "cluster".}
    \item{meany1}{Character string, y-axis title in mean plot for initial clusters, default "mean -log10 p-value".}

    \item{mean2}{Logical, default \code{TRUE}. If \code{TRUE}, plots mean over p-values of GO terms in final modules.}
    \item{meanTitle2}{Character string, title for mean plot for final modules, default "Module Performance".}
    \item{meanx2}{Character string, legend for mean plot for final modules, default "module".}
    \item{meany2}{Character string, y-axis title in mean plot for final modules, default "mean -log10 p-value".}

    \item{pie1}{Logical, default \code{TRUE}. If \code{TRUE}, plots pie chart of direction and ontology of GO terms for initial clusters.}
    \item{pieTitle1}{Character string, title for pie plot for initial clusters, default "Initial GO Analysis".}
    \item{piex1}{Character string, x-axis title for pie plot for initial clusters, default "cluster".}
    \item{piey1}{Character string, y-axis title in pie plot for initial clusters, default "count".}
    \item{posx1}{Numeric, position of label of -log10 p-value of the most significant term, default 1.8.}

    \item{pie2}{Logical, default \code{TRUE}. If \code{TRUE}, plots pie chart of direction and ontology of GO terms for final modules.}
    \item{pieTitle2}{Character string, title for pie plot for final modules, default "Final GO Analysis".}
    \item{piex2}{Character string, x-axis title for pie plot for final modules, default "module".}
    \item{piey2}{Character string, y-axis title in pie plot for final modules, default "count".}
    \item{posx2}{Numeric, position of label of -log10 p-value of the most significant term, default 1.8.}
}

\value{
    Returns the plotting object for each plot if \code{keep} is \code{TRUE}.
}

\references{
        \href{https://arxiv.org/abs/2209.10545}{Aghaieabiane, N and Koutis, I (2022) SGCP: A semi-supervised pipeline for gene clustering using self-training approach in gene co-expression networks}
    }

\seealso{
    \href{https://github.com/na396/SGCP}{SGCP Toturial}
}

\examples{

library(SGCP)
library(SummarizedExperiment)

# load the result of ezSGCP function
data(sgcp)

# load the input expression dataset
data(cheng)
expData <- assay(cheng)

# to call the function uncomment the following
## plt <- SGCP_ezPLOT(sgcp = sgcp, expreData = cheng, keep = TRUE)

## print(plt)

}
