% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sehm.R
\name{sehm}
\alias{sehm}
\title{sehm}
\usage{
sehm(
  se,
  genes,
  do.scale = FALSE,
  assayName = .getDef("assayName"),
  sortRowsOn = seq_len(ncol(se)),
  cluster_cols = FALSE,
  cluster_rows = is.null(sortRowsOn),
  toporder = NULL,
  hmcols = NULL,
  breaks = .getDef("breaks"),
  gaps_at = .getDef("gaps_at"),
  gaps_row = NULL,
  anno_rows = .getDef("anno_rows"),
  anno_columns = .getDef("anno_columns"),
  anno_colors = NULL,
  show_rownames = NULL,
  show_colnames = FALSE,
  ...
)
}
\arguments{
\item{se}{A \code{\link[SummarizedExperiment]{SummarizedExperiment-class}}.}

\item{genes}{An optional vector of genes (i.e. row names of `se`)}

\item{do.scale}{Logical; whether to scale rows (default FALSE).}

\item{assayName}{An optional vector of assayNames to use. The first available
will be used, or the first assay if NULL.}

\item{sortRowsOn}{Sort rows by MDS polar order using the specified columns
(default all)}

\item{cluster_cols}{Whether to cluster columns (default F)}

\item{cluster_rows}{Whether to cluster rows; default FALSE if
`do.sortRows=TRUE`.}

\item{toporder}{Optional verctor of categories on which to supra-order when
sorting rows, or name of a `rowData` column to use for this purpose.}

\item{hmcols}{Colors for the heatmap.}

\item{breaks}{Breaks for the heatmap colors. Alternatively, symmetrical
breaks can be generated automatically by setting `breaks` to a numerical
value between 0 and 1. The value is passed as the `split.prop` argument to
the \code{\link{getBreaks}} function, and indicates the proportion of the
points to map to a linear scale, while the more extreme values will be
plotted on a quantile scale. `breaks=FALSE` will disable symmetrical scale
and quantile capping, while retaining automatic breaks. `breaks=1` will
produce a symmetrical scale without quantile capping.}

\item{gaps_at}{Columns of `colData` to use to establish gaps between columns.}

\item{gaps_row}{Passed to the heatmap function; if missing, will
be set automatically according to toporder.}

\item{anno_rows}{Columns of `rowData` to use for left annotation.}

\item{anno_columns}{Columns of `colData` to use for top annotation.}

\item{anno_colors}{List of colors to use for annotation.}

\item{show_rownames}{Whether to show row names (default TRUE if less than
50 rows to plot).}

\item{show_colnames}{Whether to show column names (default FALSE).}

\item{...}{Further arguments passed to `pheatmap`}
}
\value{
A heatmap.
}
\description{
Deprecated pheatmap wrapper for
\code{\link[SummarizedExperiment]{SummarizedExperiment-class}}.
**This function has been replaced by the \code{\link[sechm]{sechm}} function
from the `sechm` package and is retained here solely for backward 
compatibility.**
}
