% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/castSE.R
\name{castSE}
\alias{castSE}
\title{castSE}
\usage{
castSE(
  x,
  rowNames = NULL,
  colNames = NULL,
  assayNames = NULL,
  colData = NULL,
  rowData = NULL,
  sparse = FALSE
)
}
\arguments{
\item{x}{A data.frame}

\item{rowNames}{Column of `x` containing the row.names (if omitted, will build from
`rowData`)}

\item{colNames}{Column of `x` containing the column names (if omitted, will build from
`colData`)}

\item{assayNames}{Columns of `x` to turn into assays}

\item{colData}{Columns of `x` to use as colData}

\item{rowData}{Columns of `x` to use as rowData}

\item{sparse}{Local, whether to keep the assays sparse.}
}
\value{
A \code{\link[SummarizedExperiment]{SummarizedExperiment-class}}
}
\description{
Casts a data.frame as a \code{\link[SummarizedExperiment]{SummarizedExperiment-class}}
}
\examples{
d <- data.frame(transcript=rep(LETTERS[1:10],each=2), gene=rep(LETTERS[1:5],each=4),
                count=rpois(20, 10), sample=letters[1:2])
head(d)
castSE(d, rowData=c("transcript","gene"), colNames="sample")
}
