% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggSE}
\alias{aggSE}
\title{aggSE}
\usage{
aggSE(x, by, assayFun = NULL, rowDatFuns = list())
}
\arguments{
\item{x}{An object of class `SummarizedExperiment`}

\item{by}{Vector by which to aggregate, or column of `rowData(x)`}

\item{assayFun}{Function by which to aggregate, or a list of such functions
(or vector of function names) of the same length as there are assays. If NULL
will attempt to use an appropriate function (and notify the functions used),
typically the mean.}

\item{rowDatFuns}{A named list providing functions by which to aggregate each
rowData columns. If a given column has no specified function, the default
will be used, i.e. logical are transformed into a proportion, numerics are
aggregated by median, and unique factors/characters are pasted together. Use
`rowDataFuns=NULL` to discard rowData.}
}
\value{
An object of class `SummarizedExperiment`
}
\description{
Aggregates the rows of a `SummarizedExperiment`.
}
\examples{
library(SummarizedExperiment)
data("SE", package="SEtools")
# arbitrary IDs for example aggregation:
rowData(SE)$otherID <- rep(LETTERS[1:10],each=10)
SE <- aggSE(SE, "otherID")
}
