% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{plotRaster}
\alias{plotRaster}
\title{plotRaster}
\usage{
plotRaster(
  input,
  assay_name = NULL,
  feature_name = "sum",
  factor_levels = NULL,
  showLegend = TRUE,
  plotTitle = NULL,
  showAxis = FALSE,
  ...
)
}
\arguments{
\item{input}{\code{SpatialExperiment}: Input data represented as a 
\code{SpatialExperiment}. The given \code{SpatialExperiment} is assumed to have 
an \code{assay} slot containing a features-by-observations matrix as \code{dgCmatrix} 
or \code{matrix} and a \code{colData} slot containing \code{sfc_POLYGON} geometry 
of pixels. The features-by-observations matrix is assumed to have either genes 
or cell types as features and pixels as observations.}

\item{assay_name}{\code{character}: Name of the assay slot of the input that 
you want to visualize. If no argument is given, the first assay of the input 
would be visualized. This argument is useful when you have multiple assays stored 
in the input, and you want to visualize a specific assay. Default is NULL.}

\item{feature_name}{\code{character}: Name of the feature in the input that you 
want to visualize. This argument is useful when you want to specify a feature you 
want to visualize. You can also use "sum" to visualize sum of all feature 
values per observation or "mean" to visualize mean of all feature values per observation. 
Default is "sum".}

\item{factor_levels}{\code{character} or \code{numeric} or \code{factor}: An 
optional vector to convert and plot the input data as \code{factor}. This argument 
is useful if you want to plot categorical/ordinal variables, such as binarized 
occurrence of a specific cell type. \code{factor_levels} is fed into \code{levels} 
argument of the \code{factor} function in base R. Default is NULL.}

\item{showLegend}{\code{logical}: Boolean to show the legend. Default is TRUE.}

\item{plotTitle}{\code{character}: An optional argument to add a title to the 
resulting plot. Default is NULL.}

\item{showAxis}{\code{logical}: Boolean to show axis title, texts, and ticks. 
Default is FALSE.}

\item{...}{Additional parameters to pass to \code{ggplot2::scale_fill_viridis_c} 
if no argument is provided to \code{factor_levels} or \code{ggplot2::scale_fill_viridis_d} 
if a vector is provided to \code{factor_levels}. If you wish to use other color 
maps, we recommend overriding the resulting \code{ggplot} object.}
}
\value{
The output is returned as a \code{ggplot} object, where the input is 
visualized as \code{ggplot2::geom_sf}. Each pixel is plotted based on \code{sfc_POLYGON} 
geometry stored in the \code{colData} slot. Coloring of pixel represent the corresponding 
values of summarized (sum or mean) or specific feature (e.g. rasterized gene expression) 
per observation (pixel).
}
\description{
Function based on \code{ggplot2::geom_tile} to visualize a rasterized spatial omics dataset represented as a \code{SpatialExperiment} object.
}
\examples{
data("merfish_mousePOA")

# rasterize gene expression
out <- rasterizeGeneExpression(merfish_mousePOA, assay_name = "volnorm", fun = "mean")

# plot total rasterized gene expression per pixel (there is only one assay_name 
# in out and default for feature_name argument is "sum"; therefore, these arguments 
# are not specified)
plotRaster(out, name = "total rasterized gexp")

# plot rasterized expression of a specific gene/feature per pixel
plotRaster(out, feature_name = "Esr1", name = "Esr1")

# rasterize cell-type labels with user-defined resolution and hexagonal pixels
out <- rasterizeCellType(merfish_mousePOA, col_name = "celltype", resolution = 50, 
square = FALSE, fun = "sum")

# plot total cell counts per pixel (there is only one assay_name in out and default 
# for feature_name argument is "sum"; therefore, these arguments are not specified)
# here, let's use additional parameters for ggplot2::scale_fill_viridis_c so 
# that it would have a different color scheme from gene expression plots
plotRaster(out, name = "total cell counts", option = "inferno")

# plot specific cell type's cell counts per pixel
plotRaster(out, feature_name = "Inhibitory", name = "Inhibitory neuron counts", option = "inferno")

}
