% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCountDepth.R
\name{plotCountDepth}
\alias{plotCountDepth}
\title{Evaluate the count-depth relationship before (or after) normalizing
the data.}
\usage{
plotCountDepth(
  Data,
  NormalizedData = NULL,
  Conditions = NULL,
  Tau = 0.5,
  FilterCellProportion = 0.1,
  FilterExpression = 0,
  NumExpressionGroups = 10,
  NCores = NULL,
  ditherCounts = FALSE
)
}
\arguments{
\item{Data}{can be a matrix of single-cell expression with cells
where rows are genes and columns are samples. Gene names should
not be a column in this matrix, but should be assigned to rownames(Data).
Data can also be an object of class \code{SummarizedExperiment} that contains 
the single-cell expression matrix and other metadata. The \code{assays} 
slot contains the expression matrix and is named \code{"Counts"}.  
This matrix should have one row for each gene and one sample for each column.  
The \code{colData} slot should contain a data.frame with one row per 
sample and columns that contain metadata for each sample.  This data.frame
should contain a variable that represents biological condition 
in the same order as the columns of \code{NormCounts}). 
Additional information about the experiment can be contained in the
\code{metadata} slot as a list.}

\item{NormalizedData}{matrix of normalized expression counts. Rows are
genesand columns are samples. Only input this if evaluating already
normalized data.}

\item{Conditions}{vector of condition labels, this should correspond to 
the columns of the un-normalized expression matrix. If not provided data
is assumed to come from same condition/batch.}

\item{Tau}{value of quantile for the quantile regression used to
estimate gene-specific slopes (default is Tau = .5 (median)).}

\item{FilterCellProportion}{the proportion of non-zero expression estimates
required to include the genes into the evaluation. Default is .10, and 
will not go below a proportion which uses less than 10 total cells/samples.}

\item{FilterExpression}{exclude genes having median of non-zero expression
below this threshold from count-depth plots (default = 0).}

\item{NumExpressionGroups}{the number of groups to split the data into,
genes are split into equally sized groups based on their non-zero median
expression.}

\item{NCores}{number of cores to use, default is detectCores() - 1. 
This will be used to set up a parallel environment using either MulticoreParam (Linux, Mac) 
or SnowParam (Windows) with NCores using the package BiocParallel.}

\item{ditherCounts}{whether to dither/jitter the counts, may be used for
data with many ties, default is FALSE.}
}
\value{
returns a data.frame containing each gene's slope (count-depth relationship)
and its associated expression group. A plot will be output.
}
\description{
Quantile regression is used to estimate the dependence of read
 counts on sequencing depth for every gene. If multiple conditions are
 provided, a separate plot is provided for each and the filters are 
 applied within each condition separately. The plot can be used to evaluate
 the extent of the count-depth relationship in the dataset or can be be
 used to evaluate data normalized by alternative methods.
}
\examples{
 
data(ExampleSimSCData)
Conditions = rep(c(1,2), each= 90) 
#plotCountDepth(Data = ExampleSimSCData, Conditions = Conditions, 
  #FilterCellProportion = .1)
}
\author{
Rhonda Bacher
}
