% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bam_bed.R
\name{get_bam_bed}
\alias{get_bam_bed}
\title{Get bam file directories, sample names, and whole genomic bins}
\usage{
get_bam_bed(bamdir, sampname, hgref = "hg19", resolution = 500, 
            sex = FALSE)
}
\arguments{
\item{bamdir}{vector of the directory of a bam file. Should be in the same
order as sample names in \code{sampname}.}

\item{sampname}{vector of sample names. Should be in the same order as bam
directories in \code{bamdir}.}

\item{hgref}{reference genome. This should be 'hg19', 'hg38' or 'mm10'. 
Default is human genome \code{hg19}.}

\item{resolution}{numeric value of fixed bin-length. Default is \code{500}.
Unit is "kb".}

\item{sex}{logical, whether to include sex chromosomes. 
Default is \code{FALSE}.}
}
\value{
A list with components
    \item{bamdir}{A vector of bam directories}
    \item{sampname}{A vector of sample names}
    \item{ref}{A GRanges object specifying whole genomic bin positions}
}
\description{
Get bam file directories, sample names, and whole genomic
bins from .bed file
}
\examples{
library(WGSmapp)
library(BSgenome.Hsapiens.UCSC.hg38)
bamfolder <- system.file('extdata', package = 'WGSmapp')
bamFile <- list.files(bamfolder, pattern = '*.dedup.bam$')
bamdir <- file.path(bamfolder, bamFile)
sampname_raw <- sapply(strsplit(bamFile, '.', fixed = TRUE), '[', 1)
bambedObj <- get_bam_bed(bamdir = bamdir, sampname = sampname_raw, 
                        hgref = "hg38")
bamdir <- bambedObj$bamdir
sampname_raw <- bambedObj$sampname
ref_raw <- bambedObj$ref

}
\author{
Rujin Wang \email{rujin@email.unc.edu}
}
