\name{SCANVISvisual}
\alias{SCANVISvisual}
\title{a sashimi-style visualization tool}
\description{
This function quickly generates color-coded sashimi plots for SCANVIS outputs showing SJs for a query gene or a specific genomic region. 
Annotated SJs are depicted with grey arcs, while different colors segregate unannotated SJs. Arc height and thickness correspond to the junction read support and RRS score respectively. If the supplied junction file is output from SCANVISlinkvar output, variants are also plotted. If the bam file is supplied, a normalized read coverage profile is shown as an inverted read profile for a single sample. A bam file can only be supplied with one sample, and when supplied users must operate this SCANVISvisual function from a writeable directory. Users may submit multiple samples in which case the SCANVISmerge function kicks in to merge the samples, so that the resulting sashimi plot shows the union of SJs over the submitted sample cohort, with RRS scores and read support averaged over the samples. This is useful for comparing disease cohorts.
}
\usage{
SCANVISvisual(roi, gen, scn, SJ.special = NULL, TITLE = NULL, bam =
                 NULL, samtools = NULL, full.annot = FALSE, USJ = "NR")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
\item{roi}{gene name OR region of interest (chr,start,end as 3-bit vector)}
\item{gen}{gen annotation object as generated by the function SCANVISannotation.R}
\item{scn}{matrix OR list of url/s to output from SCANVISscan/linkvar (which will be submitted to SCANVISmerge) OR output from SCANVISmerge for a set of samples already merged}
\item{SJ.special}{3 col matrix indicating chr,start,end of any SJs of interest to be highlighted in cyan (default=NULL)}
\item{TITLE}{figure name/title (default=NULL)}
\item{bam}{url to one bam file corresponding to the input scn (not applicable for multiple/merged samples, default=NULL); 
the bam url is used to create a read profile in your plot, and during the processing of the bam file, temporary read pileup files
are written to your current working directory where you must have write permission}
\item{samtools}{url to samtools which MUST be specified if bam is supplied (default=NULL)}
\item{full.annot}{TRUE for each isoform listed separately, FALSE for concise format (default=FALSE)}
\item{USJ}{"NR" or "RRS" where NR induces the function to print the Number of supporting Reads above unannotated junction arcs, while RRS induces the function to print the RRS score as computed by SCANVISscan (default="NR")}
}
%\details{
%Requires packages IRanges and plotrix
%%  ~~ If necessary, more details than the description above ~~
%}
\value{Returns a sashimi-style plot depicting the relevant SJs, as well as an object with the coordinates of the genomic region, the SJs and any variants in the figure}
%\references{Sashimi style plots inspired by Miso software (https://doi.org/10.1038/nmeth.1528)}
%\author{Phaedra Agius <pagius@nygenome.org>}
%\note{
%}


\seealso{SCANVISscan, SCANVISlinkvar}
\examples{
data(SCANVISexamples)
### exon skip events in PPA2 in two LUSC samples
par(mfrow=c(2,1),mar=c(1,1,1,1))
vis.lusc1<-SCANVISvisual('PPA2',gen19,LUSC[[1]],TITLE=names(LUSC)[1],full.annot=TRUE)
vis.lusc2<-SCANVISvisual('PPA2',gen19,LUSC[[2]],TITLE=names(LUSC)[2],full.annot=TRUE,USJ='RRS')
### if bam file were available for LUSC1 ...
#vis.lusc1<-SCANVISvisual('PPA2',gen19,LUSC[[1]],TITLE=names(LUSC)[1],full.annot=TRUE,bam=<BAM4LUSC1>,samtools=<SAMTOOLS>)

### sashimi plots with variants
gbm3.scn<-SCANVISscan(sj=gbm3,gen=gen19,Rcut=5)
gbm3.scnv<-SCANVISlinkvar(gbm3.scn,gbm3.vcf,gen19)
vis.gbm3<-SCANVISvisual('PTGDS',gen19,gbm3.scnv,TITLE='gbm3')
roi<-vis.gbm3$roi
d<-diff(as.numeric(roi[2:3])) 
roi2<-c(roi[1],round(as.numeric(roi[2])+(d*0.1)),round(as.numeric(roi[3])-(d*0.5)))
### Supply exact coordinates instead of gene names ... Zooming in for gbm3
vis.gbm3.zoom<-SCANVISvisual(roi2,gen19,gbm3.scnv)

### plot multiple genes ... PTGDS and neighbors
vis.gbm3.multiple_genes<-SCANVISvisual(c('FBXW5','PTGDS','C9orf142'),gen19,gbm3.scnv,TITLE='gbm3')

par(mfrow=c(2,1),mar=c(1,1,1,1))
### see PTGDS in merge of 3 GBMs 
GBM.PTGDS<-SCANVISvisual('PTGDS',gen19,GBM,TITLE='GBM, merged',full.annot=TRUE)
#### see PTGDS in merge of 3 LUADs ... no exon skips
LUAD.PTGDS<-SCANVISvisual('PTGDS',gen19,LUAD,TITLE='LUAD, merged',full.annot=TRUE)

### NEs in GPR116 in LUAD, but not in GBM
par(mfrow=c(2,1),mar=c(1,1,1,1))
GBM.GPR116<-SCANVISvisual('GPR116',gen19,GBM,TITLE='GBM, merged',full.annot=TRUE)
LUAD.GPR116<-SCANVISvisual('GPR116',gen19,LUAD,TITLE='LUAD, merged',full.annot=TRUE)

}
\keyword{sashimi}
\keyword{cohort}

