\name{SCANVISmerge}
\alias{SCANVISmerge}
\title{merges multiple SCANVISsamples}
\description{
With this function, the RRS scores and number of supporting reads across a number of samples are collected into matrices by collecting the union of all SJs. Furthermore, a representative sample is assembled by computing the mean (or median) of RRSs and supporting reads across all samples - this may be used to visualize a cohort in one figure (see SCANVISvisual).}
\usage{
SCANVISmerge(scn, method = "mean", roi = NULL, gen = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{scn}{list of SCANVISmatrices OR character vector of urls pointing to SCANVISmatrix outputs}
  \item{method}{method for computing a RRS/uniq.reads representative, either "mean" or "median" (default="mean")}
  \item{roi}{NULL for all SJs OR chromosome name for a query chromosome (eg. chr1) OR 3 bit vector (chr, start, end) indicating region of interest OR a vector with one or more gene names (default=NULL in which case all SJs are merged)}
  \item{gen}{gencode object as generated by SCANVISannotation which must be supplied if roi is a list of one or more gene names, otherwise NULL (default=NULL)}
}
%\details{
%Requires packages IRanges and plotrix
%%  ~~ If necessary, more details than the description above ~~
%}
\value{Returns a list object ready for use in SCANVISvisual with the following details:
  \item{RRS}{a matrix with RRS scores for each sample (columns) and the union of SJs across all samples (rows)}
  \item{NR}{a matrix with number of SJ reads each sample (columns) and the union of SJs across all samples (rows)}
  \item{MUTS}{a binary matrix with 1 indicating presence of a mutation (row) in a sample (column), generated only if samples submitted were variant-mapped SJs}
  \item{SJ}{a representative sample with mean/median RRS and uniq.reads that can be used in SCANVISvisual to visualize sample cohort}
  \item{roi}{genomic coordinates for region of interest used to derive resulting data}
%  \item{sj}{a typical SCANVISoutput matrix with averaged RRSs and averaged uniq.reads (integer values, rounded up) which can be submitted directly to SCANVISvisual}
 % \item{sj.samples}{matrix with SJs as rownames (chr,start,end), comma separated sample ids, and corresponding RRS scores and uniq.rads in columns 1,2,3 for those samples hosting hosting the SJ}
  %\item{muts}{mutation details, counts and samples containing the mutation}
}

\note{For 50 or more samples, roi cannot be NULL as resulting matrices may be too large. For cohort agglomeration, please consider agglomerating chromosome by chromosome.}

%\author{Phaedra Agius <pagius@nygenome.org>}
\seealso{SCANVISscan, SCANVISlinkvar, SCANVISvisual}
\examples{
data(SCANVISexamples)
### merge all SJs across in sample list GBM
GBM.merged<-SCANVISmerge(GBM)
### only merge SJs intersecting with gene PTGDS
GBM.merged<-SCANVISmerge(GBM,'mean','PTGDS',gen19)
}

\keyword{merge}
\keyword{cohort}

