% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotPPiProfiles}
\alias{plotPPiProfiles}
\title{Plot thermal profile of protein pairs}
\usage{
plotPPiProfiles(tpcaObj, pair, splinesDf = 4)
}
\arguments{
\item{tpcaObj}{a tpcaObj after having performed
a differential analysis, see \code{runDiffTPCA}}

\item{pair}{character vector of one or more
protein names}

\item{splinesDf}{numeric, degree of freedom of 
the spline fit to the melting curves}
}
\value{
ggplot displaying the thermal profile 
of a protein pair across conditions
}
\description{
Plot thermal profile of protein pairs
}
\examples{
library(Biobase)

set.seed(12)
m1 <- matrix(rnorm(50), ncol = 10)
m2 <- matrix(rnorm(50), ncol = 10)

rownames(m1) <- letters[1:5]
rownames(m2) <- letters[1:5]

colnames(m1) <- paste("fc", 1:10, sep = "_")
colnames(m2) <- paste("fc", 1:10, sep = "_")

pheno <- data.frame(
    temperature = seq(37, 67, length.out = 10))
rownames(pheno) <- paste("fc", 1:10, sep = "_")

eset1 <- ExpressionSet(
    assayData = m1,
    phenoData = AnnotatedDataFrame(pheno)
)

eset2 <- ExpressionSet(
    assayData = m2,
    phenoData = AnnotatedDataFrame(pheno)
)

tpcaObj <- new("tpcaResult",
               ObjList = list(eset1),

ContrastList = list(eset2),
                CtrlCondName = "control",
                ContrastCondName = "treatment")

plotPPiProfiles(tpcaObj, pair = c("b", "d"))

}
