% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqcCycleGCCalc.R, R/rqcCycleGCPlot.R
\name{rqcCycleGCCalc}
\alias{rqcCycleGCCalc}
\alias{rqcCycleGCPlot}
\title{Per cycle percentual GC plot}
\usage{
rqcCycleGCCalc(rqcResultSet)

rqcCycleGCPlot(rqcResultSet)
}
\arguments{
\item{rqcResultSet}{list of \code{RqcResultSet} objects created by
\code{\link{rqc}} and \code{\link{rqcQA}} functions.}
}
\value{
Plot object from \code{\link{ggplot}} function.
}
\description{
Creates a line graph of per cycle percentual GC.
}
\section{Functions}{
\itemize{
\item \code{rqcCycleGCCalc}: calculates necessary statistics
}}

\examples{

checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
rqcCycleGCPlot(rqcResultSet)

}
\author{
Welliton Souza
}
\keyword{graphics}
\keyword{qc}
