% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqcCycleAverageQualityPcaCalc.R,
%   R/rqcCycleAverageQualityPcaPlot.R
\name{rqcCycleAverageQualityPcaCalc}
\alias{rqcCycleAverageQualityPcaCalc}
\alias{rqcCycleAverageQualityPcaPlot}
\title{Biplot of PCA of per cycle read average quality}
\usage{
rqcCycleAverageQualityPcaCalc(rqcResultSet)

rqcCycleAverageQualityPcaPlot(rqcResultSet)
}
\arguments{
\item{rqcResultSet}{list of \code{RqcResultSet} objects created by
\code{\link{rqc}} and \code{\link{rqcQA}} functions.}
}
\value{
Plot object from \code{\link{ggplot}} function.
}
\description{
This function creates a Biplot of PCA of per cycle read average quality
}
\section{Functions}{
\itemize{
\item \code{rqcCycleAverageQualityPcaCalc}: calculates necessary statistics
}}

\examples{

checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
rqcCycleAverageQualityPcaPlot(rqcResultSet)

}
\author{
Welliton Souza
}
\keyword{graphics}
\keyword{qc}
