% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RqcResultSet.R
\docType{class}
\name{RqcResultSet-class}
\alias{RqcResultSet-class}
\alias{perCycleBasecall}
\alias{perCycleBasecall,RqcResultSet-method}
\alias{perCycleBasecall,list-method}
\alias{perCycleQuality}
\alias{perCycleQuality,RqcResultSet-method}
\alias{perCycleQuality,list-method}
\alias{perFileInformation}
\alias{perFileInformation,RqcResultSet-method}
\alias{perFileInformation,list-method}
\alias{perFileTopReads}
\alias{perFileTopReads,RqcResultSet-method}
\alias{perFileTopReads,list-method}
\alias{perReadFrequency}
\alias{perReadFrequency,RqcResultSet-method}
\alias{perReadFrequency,list-method}
\alias{perReadQuality}
\alias{perReadQuality,RqcResultSet-method}
\alias{perReadQuality,list-method}
\alias{perReadWidth}
\alias{perReadWidth,RqcResultSet-method}
\alias{perReadWidth,list-method}
\title{Class RqcResultSet}
\usage{
perCycleBasecall(x)

\S4method{perCycleBasecall}{RqcResultSet}(x)

\S4method{perCycleBasecall}{list}(x)

perCycleQuality(x)

\S4method{perCycleQuality}{RqcResultSet}(x)

\S4method{perCycleQuality}{list}(x)

perFileInformation(x)

\S4method{perFileInformation}{RqcResultSet}(x)

\S4method{perFileInformation}{list}(x)

perFileTopReads(x)

\S4method{perFileTopReads}{RqcResultSet}(x)

\S4method{perFileTopReads}{list}(x)

perReadFrequency(x)

\S4method{perReadFrequency}{RqcResultSet}(x)

\S4method{perReadFrequency}{list}(x)

perReadQuality(x)

\S4method{perReadQuality}{RqcResultSet}(x)

\S4method{perReadQuality}{list}(x)

perReadWidth(x)

\S4method{perReadWidth}{RqcResultSet}(x)

\S4method{perReadWidth}{list}(x)
}
\arguments{
\item{x}{\code{RqcResultSet} object or \code{list}
of \code{RqcResultSet} objects}
}
\value{
data frame

data frame

data frame

data frame

data frame

data frame

data frame
}
\description{
Class RqcResultSet

Frequency distribution of cycle-specific base call

Frequency distribution of cycle-specific quality

File information

Top over-represented sequencing reads

Read frequency table

Frequency distribution of per read mean quality

Frequency distribution of read width
}
\examples{
checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
head(perCycleBasecall(rqcResultSet))
head(perCycleQuality(rqcResultSet))
head(perReadFrequency(rqcResultSet))
head(perReadQuality(rqcResultSet))
head(perReadWidth(rqcResultSet))
perFileInformation(rqcResultSet)
perFileTopReads(rqcResultSet)
}
