% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{calculateGCV}
\alias{calculateGCV}
\alias{calculateGCV,Rnits-method}
\alias{calculateGCV,character,ANY-method}
\title{Calculate the optimal B-spline model using generalized cross-validation}
\usage{
calculateGCV(object, topcomp = 5)

\S4method{calculateGCV}{Rnits}(object, topcomp = 5)
}
\arguments{
\item{object}{\code{\linkS4class{Rnits}} object}

\item{topcomp}{The number of top eigenvectors to be used for computation}
}
\value{
A list object with fields 'degree', 'df' for each time series data set.
}
\description{
Calculate the optimal B-spline model using generalized cross-validation
}
\details{
The optimal B-spline model is chosen as the largest model that minimizes the cross validation error of the top N eigenvectors of each time series data.
}
\examples{
# load pre-compiled expressionSet object for Ronen and Botstein yeast chemostat data
data(yeastchemostat)
rnitsobj = build.Rnits(yeastchemostat, logscale = TRUE, normmethod = 'Between')
opt_model <- calculateGCV(rnitsobj)
\dontrun{
rnitsobj <- fit(rnitsobj, gene.level = TRUE, model = opt.model)
}
}

