% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize.R
\name{optimize_parameter}
\alias{optimize_parameter}
\title{optimize_parameter}
\usage{
optimize_parameter(
  fun = est_power,
  opt1,
  opt2,
  opt1Value,
  opt2Value,
  main,
  ...
)
}
\arguments{
\item{fun}{function to be optimized, can be est_power, sample_size.}

\item{opt1}{parameter1 to be optimized.}

\item{opt2}{parameter2 to be optimized.}

\item{opt1Value}{values of parameter1 to be optimized.}

\item{opt2Value}{values of parameter2 to be optimized.}

\item{main}{Title of optimization result figure.}

\item{...}{Other parameters for optimized funtion.}
}
\value{
A power or sample size matrix, generated by different pair of two paramters.
}
\description{
A function to optimize the parameters in power or sample size estimation.
}
\details{
A function to optimize the parameters in power or sample size estimation.
}
\examples{
#Optimization for power estimation
result<-optimize_parameter(fun=est_power,opt1="n",opt2="lambda0",opt1Value=c(3,5,10,15,20),
opt2Value=c(1:5,10,20))
#Optimization for sample size estimation
result<-optimize_parameter(fun=sample_size,opt1="lambda0",opt2="phi0",opt1Value=c(1,3),
opt2Value=c(1.5,2),power=0.8)
}
