% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{est_power_distribution}
\alias{est_power_distribution}
\title{est_power_distribution}
\usage{
est_power_distribution(
  n,
  f = 0.1,
  m = 10000,
  m1 = 100,
  w = 1,
  k = 1,
  rho = 2,
  repNumber = 100,
  dispersionDigits = 1,
  distributionObject,
  libSize,
  minAveCount = 5,
  maxAveCount = 2000,
  selectedGenes,
  pathway,
  species = "hsa",
  storeProcess = FALSE,
  countFilterInRawDistribution = TRUE,
  selectedGeneFilterByCount = FALSE,
  removedGene0Power = TRUE
)
}
\arguments{
\item{n}{Numer of samples.}

\item{f}{FDR level}

\item{m}{Total number of genes for testing.}

\item{m1}{Expected number of prognostic genes.}

\item{w}{Ratio of normalization factors between two groups.}

\item{k}{Ratio of sample size between two groups (Treatment/Control).}

\item{rho}{minimum fold changes for prognostic genes between two groups (Treatment/Control).}

\item{repNumber}{Number of genes used in estimation of read counts and dispersion distribution.}

\item{dispersionDigits}{Digits of dispersion.}

\item{distributionObject}{A DGEList object generated by est_count_dispersion function. RnaSeqSampleSizeData package contains 13 datasets from TCGA, you can set distributionObject as any one of "TCGA_BLCA","TCGA_BRCA","TCGA_CESC","TCGA_COAD","TCGA_HNSC","TCGA_KIRC","TCGA_LGG","TCGA_LUAD","TCGA_LUSC","TCGA_PRAD","TCGA_READ","TCGA_THCA","TCGA_UCEC" to use them.}

\item{libSize}{numeric vector giving the total count for each sample. If not specified, the libsize in distributionObject will be used.}

\item{minAveCount}{Minimal average read count for each gene. Genes with smaller read counts will not be used.}

\item{maxAveCount}{Maximal average read count for each gene. Genes with larger read counts will be taken as maxAveCount.}

\item{selectedGenes}{Optianal. Name of interesed genes. Only the read counts and dispersion distribution for these genes will be used in power estimation.}

\item{pathway}{Optianal. ID of interested KEGG pathway. Only the read counts and dispersion distribution for genes in this pathway will be used in power estimation.}

\item{species}{Optianal. Species of interested KEGG pathway.}

\item{storeProcess}{Logical. Store the power and n in sample size or power estimation process.}

\item{countFilterInRawDistribution}{Logical. If the count filter will be applied on raw count distribution. If not, count filter will be applied on libSize scaled count distribution.}

\item{selectedGeneFilterByCount}{Logical. If the count filter will be applied to selected genes when selectedGenes parameter was used.}

\item{removedGene0Power}{Logical. When selectedGenes or pathway are used, some genes may have read count less than minAveCount and will be removed by count filter. This parameter indicates if they will be used as 0 power in power estimation. If not, they will not be used in power estimation.}
}
\value{
Average power or a list including count ,distribution and power for each gene.
}
\description{
A function to estitamete the power for differential expression analysis of RNA-seq data.
}
\details{
A function to estitamete the power for differential expression analysis of RNA-seq data.
}
\examples{
#Please note here the parameter repNumber was very small (2) to make the example code faster.
#We suggest repNumber should be at least set as 100 in real analysis.
est_power_distribution(n=65,f=0.01,rho=2,distributionObject="TCGA_READ",repNumber=2)
#Power estimation based on some interested genes. We use storeProcess=TRUE to return the 
#details for all selected genes.
selectedGenes<-c("A1BG","A2BP1","A2M","A4GALT","AAAS")
powerDistribution<-est_power_distribution(n=65,f=0.01,rho=2,distributionObject="TCGA_READ",
selectedGenes=selectedGenes,minAveCount=1,storeProcess=TRUE,repNumber=2)
str(powerDistribution)
mean(powerDistribution$power)
#Power estimation based on genes in interested pathway
\dontrun{
powerDistribution<-est_power_distribution(n=65,f=0.01,rho=2,distributionObject="TCGA_READ",
pathway="00010",minAveCount=1,storeProcess=TRUE,repNumber=2)
mean(powerDistribution$power)
}
}
