% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve.R
\name{est_power_curve}
\alias{est_power_curve}
\title{est_power_curve}
\usage{
est_power_curve(
  n,
  w = 1,
  rho = 2,
  lambda0 = 5,
  phi0 = 1,
  alpha = 0.05,
  f = 0.05,
  ...
)
}
\arguments{
\item{n}{Numer of samples.}

\item{w}{Ratio of normalization factors between two groups.}

\item{rho}{minimum fold changes for prognostic genes between two groups (Treatment/Control).}

\item{lambda0}{Average read counts for prognostic genes.}

\item{phi0}{Dispersion for prognostic genes.}

\item{alpha}{alpha level.}

\item{f}{FDR level}

\item{...}{other parameters for est_power function.}
}
\value{
A list including parameters, sample size and power.
}
\description{
A function to estitamete the power curve for differential expression analysis of RNA-seq data.
}
\examples{
result1<-est_power_curve(n=63, f=0.01, rho=2, lambda0=5, phi0=0.5)
result2<-est_power_curve(n=63, f=0.05, rho=2, lambda0=5, phi0=0.5)
plot_power_curve(list(result1,result2))
}
