% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{rnb.sample.groups}
\alias{rnb.sample.groups}
\title{rnb.sample.groups}
\usage{
rnb.sample.groups(
  annotations,
  columns = NULL,
  columns.pairs = NULL,
  min.group.size = rnb.getOption("min.group.size"),
  max.group.count = rnb.getOption("max.group.count")
)
}
\arguments{
\item{annotations}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}},
or its sample annotations in the form of a \code{data.frame}. If this parameter is
a dataset, the annotation information is extracted using the method
\code{\link[=pheno,RnBSet-method]{pheno}}.}

\item{columns}{Optional; predefined column names (in the form of a \code{character} vector) or indices (an
\code{integer} vector) to consider. All other columns in the annotation table will be ignored.}

\item{columns.pairs}{Optional; a NAMED vector containing for each column name for which paired comparisons should
be performed (say columnA) the name or index of another column (say columnB) in which same
values indicate the same pairing. columnA should be the name of the value columnB in this
vector.}

\item{min.group.size}{Minimum number of samples in each subgroup. This must be a positive \code{integer}.}

\item{max.group.count}{Maxumum number of subgroups defined by a trait. This must be an \code{integer} greater than 1.}
}
\value{
List of traits that define subgroups in the dataset. For each trait, the defined subgroups are represented by
        a list of \code{integer} vectors storing the corresponding sample indices.
}
\description{
Identifies sample subgroups defined in the given annotation information.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
str(rnb.sample.groups(rnb.set.example))
}

}
\author{
Yassen Assenov
}
