% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{rnb.run.import}
\alias{rnb.run.import}
\alias{rnb.run.qc}
\alias{rnb.run.preprocessing}
\alias{rnb.run.inference}
\alias{rnb.run.tnt}
\alias{rnb.run.exploratory}
\alias{rnb.run.differential}
\title{RnBeads Modules in the Analysis Pipeline}
\usage{
rnb.run.import(
  data.source,
  data.type = rnb.getOption("import.default.data.type"),
  dir.reports,
  init.configuration = !file.exists(file.path(dir.reports, "configuration")),
  close.report = TRUE,
  show.report = FALSE
)

rnb.run.qc(
  rnb.set,
  dir.reports,
  init.configuration = !file.exists(file.path(dir.reports, "configuration")),
  close.report = TRUE,
  show.report = FALSE
)

rnb.run.preprocessing(
  rnb.set,
  dir.reports,
  init.configuration = !file.exists(file.path(dir.reports, "configuration")),
  close.report = TRUE,
  show.report = FALSE
)

rnb.run.inference(
  rnb.set,
  dir.reports,
  init.configuration = !file.exists(file.path(dir.reports, "configuration")),
  close.report = TRUE,
  show.report = FALSE
)

rnb.run.tnt(
  rnb.set,
  dir.reports,
  init.configuration = !file.exists(file.path(dir.reports, "configuration")),
  close.report = TRUE,
  show.report = FALSE
)

rnb.run.exploratory(
  rnb.set,
  dir.reports,
  init.configuration = !file.exists(file.path(dir.reports, "configuration")),
  close.report = TRUE,
  show.report = FALSE
)

rnb.run.differential(
  rnb.set,
  dir.reports,
  init.configuration = !file.exists(file.path(dir.reports, "configuration")),
  close.report = TRUE,
  show.report = FALSE
)
}
\arguments{
\item{data.source}{\code{character} vector specifying the location of the data items on disk. The expected
length of the vector differs for different values of \code{data.type}; see
\code{\link{rnb.execute.import}} for a more detailed description.}

\item{data.type}{\code{character} vector of length one specifying the type of the input data. The value of
this parameter must be one of \code{"idat.dir"}, \code{"data.dir"}, \code{"data.files"},
\code{"GS.report"}, \code{"GEO"} or \code{"rnb.set"}. See \code{\link{rnb.execute.import}}
for a more detailed description.}

\item{dir.reports}{Directory to host the generated report file. Note that if this directory contains files,
they may be overwritten.}

\item{init.configuration}{Flag indicating if the configuration directory (usually shared among reports) should also
be created.}

\item{close.report}{Flag indicating if the created report is to be closed using the
\code{\link[=off,Report-method]{off}} method.}

\item{show.report}{Flag indicating if the report is to be displayed after it is created. If this is,
\code{TRUE} \code{\link{rnb.show.report}} is called to open the generated HTML file.}

\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}.}
}
\value{
For \code{rnb.run.import}, \code{rnb.run.preprocessing} and \code{rnb.run.inference}, the returned value is
        a list of two elements - the initialized or modified dataset and the created report. All other functions
        return the created report, invisibly.
}
\description{
Functions that start the predefined modules in the \pkg{RnBeads} analysis pipeline.
}
\details{
The functions start the import, quality control, preprocessing, covariate inference, tracks and tables,
         exploratory analysis and differential methylation modules, respectively.
}
\examples{
\donttest{
### Running the modules step by step

# Directory where your data is located
data.dir <- "~/RnBeads/data/Ziller2011_PLoSGen_450K"
idat.dir <- file.path(data.dir, "idat")
sample.annotation <- file.path(data.dir, "sample_annotation.csv")

# Directory where the output should be written to
analysis.dir <- "~/RnBeads/analysis"
# Directory where the report files should be written to
report.dir <- file.path(analysis.dir, "reports_details")
rnb.initialize.reports(report.dir)
# Set some analysis options
rnb.options(filtering.sex.chromosomes.removal = TRUE, identifiers.column = "Sample_ID")
## Restrict logging to the console only
logger.start(fname = NA)

## Data import
data.source <- c(idat.dir, sample.annotation)
result <- rnb.run.import(data.source=data.source, data.type="idat.dir", dir.reports=report.dir)
rnb.set <- result$rnb.set

## Quality Control
rnb.run.qc(rnb.set, report.dir)

## Preprocessing
rnb.set <- rnb.run.preprocessing(rnb.set, dir.reports=report.dir)$rnb.set

## Data export
rnb.options(export.to.csv = TRUE)
rnb.run.tnt(rnb.set, report.dir)

## Exploratory analysis
rnb.run.exploratory(rnb.set, report.dir)

## Differential methylation
rnb.run.differential(rnb.set, report.dir)
}

}
\seealso{
\code{\link{rnb.run.analysis}} which executes these modules in the order given above
}
\author{
Yassen Assenov
}
