% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{rnb.region.types}
\alias{rnb.region.types}
\title{rnb.region.types}
\usage{
rnb.region.types(assembly = "hg19")
}
\arguments{
\item{assembly}{Genome assembly of interest. See \code{\link{rnb.get.assemblies}} for the list of supported genomes.}
}
\value{
Region types supported by \pkg{RnBeads} in the form of a \code{character} vector. The built-in ones are
        \code{"cpgislands"}, \code{"genes"}, \code{"promoters"} and \code{"tiling"}. The names of all custom region
        definitions are also included in the returned vector.
}
\description{
Gets the supported region annotations for a given genome assembly.
}
\examples{
\donttest{
"promoters" \%in\% rnb.region.types() # TRUE
}

}
\seealso{
\code{\link{rnb.get.annotation}}, \code{\link{rnb.set.annotation}}
}
\author{
Yassen Assenov
}
