% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{rnb.execute.sex.removal}
\alias{rnb.execute.sex.removal}
\title{rnb.execute.sex.removal}
\usage{
rnb.execute.sex.removal(rnb.set)
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}.}
}
\value{
List of three elements:
        \describe{
          \item{\code{"dataset.before"}}{Copy of \code{rnb.set}.}
          \item{\code{"dataset"}}{The (possibly) modified dataset after retaining sites on autosomes only.}
          \item{\code{"filtered"}}{\code{integer} vector storing the indices (in beta matrix of the unfiltered
               dataset) of all removed probes.}
        }
}
\description{
Removes all sites in sex chromosomes from the given dataset.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
rnb.set.filtered <- rnb.execute.sex.removal(rnb.set.example)$dataset
identical(meth(rnb.set.example), meth(rnb.set.filtered)) # FALSE
}
}
\author{
Yassen Assenov
}
