% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesame.R
\name{rnb.execute.pOOBAH}
\alias{rnb.execute.pOOBAH}
\title{rnb.execute.pOOBAH}
\usage{
rnb.execute.pOOBAH(
  raw.set,
  anno.table = NULL,
  pval.thresh = 0.05,
  verbose = FALSE
)
}
\arguments{
\item{raw.set}{Methylation dataset as an instance of \code{RnBeadRawSet}.}

\item{anno.table}{Annotation for \code{raw.set}.}

\item{pval.thresh}{Computed detection p-values above this threshold are masked. Default value is 0.05.}

\item{verbose}{If set to true, a short information is printed on how many probes are masked by the method.}
}
\value{
Returns a modified \code{RnBeadRawSet}, in which signal intensities are masked, if their computed p-value  
        was greater than \code{pval.thresh}. Note, in datasets with several samples, signal intensities of a specific probe 
        might be masked in sample A, but not in sample B, as \emph{pOOBAH} is applied separately to each sample.
        For example: the signal intensities of probe cg24488772 might be masked in sample 1, but not in sample 12.
}
\description{
Probe signal intensities are masked based on their out-of-band signal intensities to counter hybridization failure.
}
\details{
rnb.execute.pOOBAH is used to apply the method \emph{pOOBAH} (P-value with OOB probes for Array Hybridization), 
which was conceived by Zhou, Triche, Laird and Shen to mask probes associated with hybridization failures. 
pOOBAH has been implemented in the R-package \emph{"sesame"}, a dependency needed for this function (see Zhou et al, 2018 and the respective Bioconductor/github pages). 
\emph{pOOBAH} computes the detection p-values by constructing 2 empirical cumulative density functions (eCDFs) based 
on the out-of-band signal intensities of the red and the green channel, respectively, to detect hybridization failures. 
The (in-band) green and red channel signal intensities of the probes are passed to the eCDFs and the probes with a 
p-value higher than the given threshold (\code{pval.thresh}) are masked, as they are considered background. 
\emph{pOOBAH} is applied \emph{separately to each sample}. 
Hybridization failures might occur due to somatic or germline deletions. 
In addition, unreliable low-intensity probes might also be masked.
}
\examples{
library(RnBeads.hg19) 
data(small.example.object)


}
\author{
\emph{pOOBAH} method: Wanding Zhou. Adapted by Nathan Steenbuck.
}
